/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.grpc.proxy;

import com.tangosol.net.management.annotation.Description;
import com.tangosol.net.management.annotation.MetricsLabels;
import com.tangosol.net.management.annotation.MetricsScope;
import com.tangosol.net.management.annotation.MetricsValue;
import com.tangosol.net.metrics.MBeanMetric;

@MetricsScope(value=MBeanMetric.Scope.VENDOR)
public interface GrpcProxyMetricsMBean {
    @MetricsValue(value="RequestCount")
    @Description(value="The count of successful requests")
    public long getSuccessfulRequestCount();

    @MetricsValue(value="RequestRate")
    @MetricsLabels(value={"rate", "15min"})
    @Description(value="The fifteen minute rate of successful requests")
    public double getSuccessfulRequestFifteenMinuteRate();

    @MetricsValue(value="RequestRate")
    @MetricsLabels(value={"rate", "5min"})
    @Description(value="The five minute rate of successful requests")
    public double getSuccessfulRequestFiveMinuteRate();

    @MetricsValue(value="RequestRate")
    @MetricsLabels(value={"rate", "1min"})
    @Description(value="The one minute rate of successful requests")
    public double getSuccessfulRequestOneMinuteRate();

    @MetricsValue(value="RequestRate")
    @MetricsLabels(value={"rate", "mean"})
    @Description(value="The mean rate of successful requests")
    public double getSuccessfulRequestMeanRate();

    @MetricsValue(value="ErrorRequestCount")
    @Description(value="The count of requests that responded with an error")
    public long getErrorRequestCount();

    @MetricsValue(value="ErrorRequestRate")
    @MetricsLabels(value={"rate", "15min"})
    @Description(value="The fifteen minute rate of requests that responded with an error")
    public double getErrorRequestFifteenMinuteRate();

    @MetricsValue(value="ErrorRequestRate")
    @MetricsLabels(value={"rate", "5min"})
    @Description(value="The five minute rate of requests that responded with an error")
    public double getErrorRequestFiveMinuteRate();

    @MetricsValue(value="ErrorRequestRate")
    @MetricsLabels(value={"rate", "1min"})
    @Description(value="The one minute rate of requests that responded with an error")
    public double getErrorRequestOneMinuteRate();

    @MetricsValue(value="ErrorRequestRate")
    @MetricsLabels(value={"rate", "mean"})
    @Description(value="The mean rate of requests that responded with an error")
    public double getErrorRequestMeanRate();

    @MetricsValue(value="MessagesReceivedCount")
    @Description(value="The count of messages received")
    public long getMessagesReceivedCount();

    @MetricsValue(value="MessagesReceivedRate")
    @MetricsLabels(value={"rate", "15min"})
    @Description(value="The fifteen minute rate of messages received")
    public double getMessagesReceivedFifteenMinuteRate();

    @MetricsValue(value="MessagesReceivedRate")
    @MetricsLabels(value={"rate", "5min"})
    @Description(value="The five minute rate of messages received")
    public double getMessagesReceivedFiveMinuteRate();

    @MetricsValue(value="MessagesReceivedRate")
    @MetricsLabels(value={"rate", "1min"})
    @Description(value="The one minute rate of messages received")
    public double getMessagesReceivedOneMinuteRate();

    @MetricsValue(value="MessagesReceivedRate")
    @MetricsLabels(value={"rate", "mean"})
    @Description(value="The mean rate of messages received")
    public double getMessagesReceivedMeanRate();

    @MetricsValue(value="ResponsesSentCount")
    @Description(value="The count of responses sent")
    public long getResponsesSentCount();

    @MetricsValue(value="ResponsesSentRate")
    @MetricsLabels(value={"rate", "15min"})
    @Description(value="The fifteen minute rate of responses sent")
    public double getResponsesSentFifteenMinuteRate();

    @MetricsValue(value="ResponsesSentRate")
    @MetricsLabels(value={"rate", "5min"})
    @Description(value="The five minute rate of responses sent")
    public double getResponsesSentFiveMinuteRate();

    @MetricsValue(value="ResponsesSentRate")
    @MetricsLabels(value={"rate", "1min"})
    @Description(value="The one minute rate of responses sent")
    public double getResponsesSentOneMinuteRate();

    @MetricsValue(value="ResponsesSentRate")
    @MetricsLabels(value={"rate", "mean"})
    @Description(value="The mean rate of responses sent")
    public double getResponsesSentMeanRate();

    @MetricsValue(value="RequestDuration")
    @MetricsLabels(value={"quantile", "75th"})
    @Description(value="The 75th percentile value from the latest request duration metric distribution")
    public double getRequestDuration75thPercentile();

    @MetricsValue(value="RequestDuration")
    @MetricsLabels(value={"quantile", "95th"})
    @Description(value="The 95th percentile value from the latest request duration metric distribution")
    public double getRequestDuration95thPercentile();

    @MetricsValue(value="RequestDuration")
    @MetricsLabels(value={"quantile", "98th"})
    @Description(value="The 98th percentile value from the latest request duration metric distribution")
    public double getRequestDuration98thPercentile();

    @MetricsValue(value="RequestDuration")
    @MetricsLabels(value={"quantile", "99th"})
    @Description(value="The 99th percentile value from the latest request duration metric distribution")
    public double getRequestDuration99thPercentile();

    @MetricsValue(value="RequestDuration")
    @MetricsLabels(value={"quantile", "99.9th"})
    @Description(value="The 99.9th percentile value from the latest request duration metric distribution")
    public double getRequestDuration999thPercentile();

    @MetricsValue(value="RequestDuration")
    @MetricsLabels(value={"quantile", "max"})
    @Description(value="The maximum value from the latest request duration metric distribution")
    public double getRequestDurationMax();

    @MetricsValue(value="RequestDuration")
    @MetricsLabels(value={"quantile", "mean"})
    @Description(value="The mean value from the latest request duration metric distribution")
    public double getRequestDurationMean();

    @MetricsValue(value="RequestDuration")
    @MetricsLabels(value={"quantile", "min"})
    @Description(value="The minimum value from the latest request duration metric distribution")
    public double getRequestDurationMin();

    @MetricsValue(value="RequestDuration")
    @MetricsLabels(value={"quantile", "stddev"})
    @Description(value="The standard deviation from the latest request duration metric distribution")
    public double getRequestDurationStdDev();

    @MetricsValue(value="MessageDuration")
    @MetricsLabels(value={"quantile", "75th"})
    @Description(value="The 75th percentile value from the latest message duration metric distribution")
    public double getMessageDuration75thPercentile();

    @MetricsValue(value="MessageDuration")
    @MetricsLabels(value={"quantile", "95th"})
    @Description(value="The 95th percentile value from the latest message duration metric distribution")
    public double getMessageDuration95thPercentile();

    @MetricsValue(value="MessageDuration")
    @MetricsLabels(value={"quantile", "98th"})
    @Description(value="The 98th percentile value from the latest message duration metric distribution")
    public double getMessageDuration98thPercentile();

    @MetricsValue(value="MessageDuration")
    @MetricsLabels(value={"quantile", "99th"})
    @Description(value="The 99th percentile value from the latest message duration metric distribution")
    public double getMessageDuration99thPercentile();

    @MetricsValue(value="MessageDuration")
    @MetricsLabels(value={"quantile", "99.9th"})
    @Description(value="The 99.9th percentile value from the latest message duration metric distribution")
    public double getMessageDuration999thPercentile();

    @MetricsValue(value="MessageDuration")
    @MetricsLabels(value={"quantile", "max"})
    @Description(value="The maximum value from the latest message duration metric distribution")
    public double getMessageDurationMax();

    @MetricsValue(value="MessageDuration")
    @MetricsLabels(value={"quantile", "mean"})
    @Description(value="The mean value from the latest message duration metric distribution")
    public double getMessageDurationMean();

    @MetricsValue(value="MessageDuration")
    @MetricsLabels(value={"quantile", "min"})
    @Description(value="The minimum value from the latest message duration metric distribution")
    public double getMessageDurationMin();

    @MetricsValue(value="MessageDuration")
    @MetricsLabels(value={"quantile", "stddev"})
    @Description(value="The standard deviation from the latest message duration metric distribution")
    public double getMessageDurationStdDev();

    @MetricsValue(value="TaskBacklog")
    @Description(value="The number of tasks that have been added to the pool, but not yet scheduled for execution")
    public int getTaskBacklog();

    @MetricsValue(value="MaxDaemonThreadCount")
    @Description(value="The maximum number of Daemon threads that could exist")
    public int getDaemonCountMax();

    public void setDaemonCountMax(int var1);

    @MetricsValue(value="MinDaemonThreadCount")
    @Description(value="The minimum number of Daemon threads that should exist")
    public int getDaemonCountMin();

    public void setDaemonCountMin(int var1);

    @MetricsValue(value="DaemonThreadCount")
    @Description(value="The number of Daemon threads that exist")
    public int getDaemonCount();

    @MetricsValue(value="AbandonedThreadCount")
    @Description(value="The total number of abandoned Daemon threads")
    public int getAbandonedThreadCount();

    @MetricsValue(value="TaskActiveMillis")
    @Description(value="The total number of milliseconds spent by all Daemon threads while executing tasks")
    public long getTaskActiveMillis();

    @MetricsValue(value="TaskHungCount")
    @Description(value="The total number of currently executing hung tasks")
    public int getHungTaskCount();

    @MetricsValue(value="TaskHungDuration")
    @Description(value="The longest currently executing hung task duration (in milliseconds)")
    public long getHungTaskDuration();

    @Description(value="The last time MBean statistics were reset")
    public long getLastResetMillis();

    @Description(value="The last time the daemon pool was resized")
    public long getLastResizeMillis();

    @MetricsValue(value="TaskAddedCount")
    @Description(value="The total number of tasks added to the pool since the last time the statistics were reset")
    public long getTaskAddCount();

    @MetricsValue(value="TaskCount")
    @Description(value="The total number of tasks executed by Daemon threads since the last time the statistics were reset")
    public long getTaskCount();

    @MetricsValue(value="TaskMaxBacklogCount")
    @Description(value="The maximum backlog value since the last time the statistics were reset")
    public int getMaxTaskBacklog();

    @MetricsValue(value="TaskTimeoutCount")
    @Description(value="The total number of timed-out tasks since the last time the statistics were reset")
    public int getTaskTimeoutCount();

    @Description(value="The default timeout value for PriorityTasks that don't explicitly specify the execution timeout value")
    public long getTaskTimeout();
}

