/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent;

import com.oracle.coherence.concurrent.config.ConcurrentServicesSessionConfiguration;
import com.tangosol.coherence.config.builder.MapBuilder;
import com.tangosol.coherence.config.scheme.NamedQueueScheme;
import com.tangosol.coherence.config.scheme.PagedQueueScheme;
import com.tangosol.coherence.config.scheme.SimpleDequeScheme;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.internal.net.ConfigurableCacheFactorySession;
import com.tangosol.internal.net.NamedCacheDeactivationListener;
import com.tangosol.internal.net.queue.NamedMapBlockingDeque;
import com.tangosol.internal.net.queue.NamedMapBlockingQueue;
import com.tangosol.internal.net.queue.NamedMapDeque;
import com.tangosol.internal.net.queue.NamedMapQueue;
import com.tangosol.internal.net.queue.paged.PagedNamedQueue;
import com.tangosol.net.Coherence;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedBlockingDeque;
import com.tangosol.net.NamedBlockingQueue;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.NamedMap;
import com.tangosol.net.NamedQueue;
import com.tangosol.net.Session;
import com.tangosol.net.ValueTypeAssertion;
import com.tangosol.net.internal.ScopedReferenceStore;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Queues {
    public static final String QUEUE_CACHE_PREFIX = "Queue$";
    public static final String PAGED_QUEUE_CACHE_PREFIX = "PagedQueue$";
    public static final String SESSION_NAME = ConcurrentServicesSessionConfiguration.SESSION_NAME;
    private static final Map<String, QueueReferenceStore> f_mapStores = new ConcurrentHashMap<String, QueueReferenceStore>();

    public static <E> NamedBlockingDeque<E> deque(String sName) {
        return Queues.deque(sName, Queues.session());
    }

    public static <E> NamedBlockingDeque<E> deque(String sName, Session session) {
        if (session == null) {
            session = Queues.session();
        }
        SimpleDequeScheme scheme = SimpleDequeScheme.INSTANCE;
        String sCacheName = Queues.isConcurrent(session) ? Queues.cacheNameForDeque(sName) : sName;
        NamedMapDeque deque = Queues.ensureCollectionInternal(sCacheName, NamedMapDeque.class, scheme, session);
        return new NamedMapBlockingDeque(sName, deque);
    }

    public static <E> NamedBlockingQueue<E> queue(String sName) {
        return Queues.queue(sName, Queues.session());
    }

    public static <E> NamedBlockingQueue<E> queue(String sName, Session session) {
        return Queues.deque(sName, session);
    }

    public static <E> NamedBlockingQueue<E> pagedQueue(String sName) {
        return Queues.pagedQueue(sName, Queues.session());
    }

    public static <E> NamedBlockingQueue<E> pagedQueue(String sName, Session session) {
        if (session == null) {
            session = Queues.session();
        }
        PagedQueueScheme scheme = PagedQueueScheme.INSTANCE;
        String sCacheName = Queues.isConcurrent(session) ? Queues.cacheNameForPagedQueue(sName) : sName;
        PagedNamedQueue queue = (PagedNamedQueue)Queues.ensureCollectionInternal(sCacheName, NamedMapQueue.class, scheme, session);
        return new NamedMapBlockingQueue(sName, (NamedMapQueue)queue);
    }

    public static String cacheNameForQueue(String sName) {
        return QUEUE_CACHE_PREFIX + sName;
    }

    public static String cacheNameForDeque(String sName) {
        return QUEUE_CACHE_PREFIX + sName;
    }

    public static String cacheNameForPagedQueue(String sName) {
        return PAGED_QUEUE_CACHE_PREFIX + sName;
    }

    protected static Session session() {
        return (Session)Coherence.findSession((String)SESSION_NAME).orElseThrow(() -> new IllegalStateException(String.format("The session '%s' has not been initialized", SESSION_NAME)));
    }

    private static boolean isConcurrent(Session session) {
        return SESSION_NAME.equals(session.getName());
    }

    private static <Q extends NamedMapQueue> Q ensureCollectionInternal(String sName, Class<Q> clzQueue, NamedQueueScheme<Q> scheme, Session session) {
        NamedMapQueue collection;
        ConfigurableCacheFactorySession ccfSession = (ConfigurableCacheFactorySession)session;
        if (sName == null || sName.isEmpty()) {
            sName = "Default";
        }
        ExtensibleConfigurableCacheFactory eccf = (ExtensibleConfigurableCacheFactory)ccfSession.getConfigurableCacheFactory();
        ClassLoader loader = eccf.getConfigClassLoader();
        String sSession = session.getName();
        QueueReferenceStore store = f_mapStores.computeIfAbsent(sSession, k -> new QueueReferenceStore());
        do {
            NamedQueue col;
            if ((col = (NamedQueue)store.get(sName, loader)) != null && col.isActive()) {
                if (clzQueue.isAssignableFrom(col.getClass())) {
                    return (Q)((NamedMapQueue)col);
                }
                String sMsg = String.format("A Collection already exist for name '%s' but is of type %s when requested type is %s", sName, col.getClass(), clzQueue);
                throw new IllegalStateException(sMsg);
            }
            store.clearInactiveRefs(sName);
            if (!scheme.realizes(clzQueue)) {
                throw new IllegalArgumentException("The specified builder cannot build a queue of type " + String.valueOf(clzQueue));
            }
            NullParameterResolver resolver = new NullParameterResolver();
            MapBuilder.Dependencies dependencies = new MapBuilder.Dependencies(ccfSession.getConfigurableCacheFactory(), null, loader, sName, null);
            collection = (NamedMapQueue)scheme.realize(ValueTypeAssertion.WITHOUT_TYPE_CHECKING, (ParameterResolver)resolver, dependencies);
            NamedMap map = collection.getNamedMap();
            map.addMapListener((MapListener)new DeactivationListener((NamedQueue<?>)collection, store));
        } while (store.putIfAbsent(collection, loader) != null);
        return (Q)collection;
    }

    protected static class QueueReferenceStore
    extends ScopedReferenceStore<NamedQueue> {
        public QueueReferenceStore() {
            super(NamedQueue.class, NamedQueue::isActive, NamedCollection::getName, NamedQueue::getService);
        }
    }

    protected static class DeactivationListener
    implements NamedCacheDeactivationListener {
        private final NamedQueue<?> m_queue;
        private final QueueReferenceStore m_store;

        public DeactivationListener(NamedQueue<?> queue, QueueReferenceStore store) {
            this.m_queue = queue;
            this.m_store = store;
        }

        public void entryInserted(MapEvent evt) {
        }

        public void entryUpdated(MapEvent evt) {
        }

        public void entryDeleted(MapEvent evt) {
            this.m_store.release(this.m_queue);
        }
    }
}

