/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.atomic;

import com.oracle.coherence.concurrent.atomic.AsyncAtomicMarkableReference;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.function.Remote;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicMarkableReference;

public class AsyncRemoteAtomicMarkableReference<V>
implements AsyncAtomicMarkableReference<V> {
    private final AsyncNamedMap<String, AtomicMarkableReference<V>> f_mapAtomic;
    private final String f_sName;

    protected AsyncRemoteAtomicMarkableReference(AsyncNamedMap<String, AtomicMarkableReference<V>> mapAtomic, String sName) {
        this.f_mapAtomic = mapAtomic;
        this.f_sName = sName;
    }

    @Override
    public CompletableFuture<V> getReference() {
        return this.invoke(AtomicMarkableReference::getReference, false);
    }

    @Override
    public CompletableFuture<Boolean> isMarked() {
        return this.invoke(AtomicMarkableReference::isMarked, false);
    }

    @Override
    public CompletableFuture<V> get(boolean[] abMarkHolder) {
        return this.invoke((Remote.Function & Serializable)value -> {
            boolean[] abMark = new boolean[1];
            Object v = value.get(abMark);
            return new Object[]{v, abMark[0]};
        }, false).thenApply(aResult -> {
            abMarkHolder[0] = (Boolean)aResult[1];
            return aResult[0];
        });
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(V expectedReference, V newReference, boolean fExpectedMark, boolean fNewMark) {
        return this.invoke((Remote.Function & Serializable)value -> {
            boolean[] abMark = new boolean[1];
            Object v = value.get(abMark);
            if (Objects.equals(v, expectedReference) && fExpectedMark == abMark[0]) {
                value.set(newReference, fNewMark);
                return true;
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<Void> set(V newReference, boolean fNewMark) {
        return this.invoke((Remote.Function & Serializable)value -> {
            value.set(newReference, fNewMark);
            return null;
        });
    }

    @Override
    public CompletableFuture<Boolean> attemptMark(V expectedReference, boolean fNewMark) {
        return this.invoke((Remote.Function & Serializable)value -> {
            Object v = value.getReference();
            if (Objects.equals(v, expectedReference)) {
                value.set(v, fNewMark);
                return true;
            }
            return false;
        });
    }

    public String toString() {
        boolean[] abMark = new boolean[1];
        V value = this.get(abMark).join();
        return String.valueOf(value) + " (" + abMark[0] + ")";
    }

    protected <R> CompletableFuture<R> invoke(Remote.Function<AtomicMarkableReference<V>, R> function) {
        return this.invoke(function, true);
    }

    protected <R> CompletableFuture<R> invoke(Remote.Function<AtomicMarkableReference<V>, R> function, boolean fMutate) {
        return this.f_mapAtomic.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
            AtomicMarkableReference value = (AtomicMarkableReference)entry.getValue();
            Object result = function.apply((Object)value);
            if (fMutate) {
                entry.setValue((Object)value);
            }
            return result;
        });
    }
}

