/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.locks;

import com.oracle.coherence.concurrent.config.ConcurrentServicesSessionConfiguration;
import com.oracle.coherence.concurrent.locks.RemoteLock;
import com.oracle.coherence.concurrent.locks.RemoteReadWriteLock;
import com.oracle.coherence.concurrent.locks.internal.ExclusiveLockHolder;
import com.oracle.coherence.concurrent.locks.internal.ReadWriteLockHolder;
import com.tangosol.net.Coherence;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Locks {
    public static final String SESSION_NAME = ConcurrentServicesSessionConfiguration.SESSION_NAME;
    private static final Map<String, ReentrantLock> f_mapExclusiveLocal = new ConcurrentHashMap<String, ReentrantLock>();
    private static final Map<String, ReentrantReadWriteLock> f_mapReadWriteLocal = new ConcurrentHashMap<String, ReentrantReadWriteLock>();
    private static final Map<String, RemoteLock> f_mapExclusive = new ConcurrentHashMap<String, RemoteLock>();
    private static final Map<String, RemoteReadWriteLock> f_mapReadWrite = new ConcurrentHashMap<String, RemoteReadWriteLock>();

    public static ReentrantLock localLock(String sName) {
        return f_mapExclusiveLocal.computeIfAbsent(sName, n -> new ReentrantLock());
    }

    public static RemoteLock remoteLock(String sName) {
        return f_mapExclusive.computeIfAbsent(sName, n -> new RemoteLock((String)n, Locks.exclusiveLocksMap()));
    }

    public static ReentrantReadWriteLock localReadWriteLock(String sName) {
        return f_mapReadWriteLocal.computeIfAbsent(sName, n -> new ReentrantReadWriteLock());
    }

    public static RemoteReadWriteLock remoteReadWriteLock(String sName) {
        return f_mapReadWrite.computeIfAbsent(sName, n -> new RemoteReadWriteLock((String)n, Locks.readWriteLocksMap()));
    }

    protected static Session session() {
        return (Session)Coherence.findSession((String)SESSION_NAME).orElseThrow(() -> new IllegalStateException(String.format("The session '%s' has not been initialized", SESSION_NAME)));
    }

    public static NamedMap<String, ExclusiveLockHolder> exclusiveLocksMap() {
        return Locks.session().getMap("locks-exclusive", new NamedMap.Option[0]);
    }

    public static NamedMap<String, ReadWriteLockHolder> readWriteLocksMap() {
        return Locks.session().getMap("locks-read-write", new NamedMap.Option[0]);
    }
}

