/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.internal.cdi;

import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.cdi.Remote;
import com.oracle.coherence.concurrent.LocalSemaphore;
import com.oracle.coherence.concurrent.RemoteSemaphore;
import com.oracle.coherence.concurrent.Semaphore;
import com.oracle.coherence.concurrent.Semaphores;
import com.oracle.coherence.concurrent.cdi.Permits;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.Member;

@ApplicationScoped
public class SemaphoreProducer {
    @Produces
    @Name(value="")
    @Permits
    @Remote
    Semaphore getSemaphore(InjectionPoint ip) {
        if (ip.getQualifiers().contains(Remote.Literal.INSTANCE)) {
            return this.getRemoteSemaphore(ip);
        }
        return this.getLocalSemaphore(ip);
    }

    @Produces
    LocalSemaphore getUnqualifiedLocalSemaphore(InjectionPoint ip) {
        return this.getLocalSemaphore(ip);
    }

    @Produces
    @Name(value="")
    @Permits
    @Typed(value={LocalSemaphore.class})
    LocalSemaphore getLocalSemaphore(InjectionPoint ip) {
        return Semaphores.localSemaphore(this.getName(ip), this.getPermits(ip));
    }

    @Produces
    @Typed(value={RemoteSemaphore.class})
    RemoteSemaphore getUnqualifiedRemoteSemaphore(InjectionPoint ip) {
        return this.getRemoteSemaphore(ip);
    }

    @Produces
    @Name(value="")
    @Permits
    @Typed(value={RemoteSemaphore.class})
    RemoteSemaphore getRemoteSemaphore(InjectionPoint ip) {
        return Semaphores.remoteSemaphore(this.getName(ip), this.getPermits(ip));
    }

    protected String getName(InjectionPoint ip) {
        String sName = ip.getQualifiers().stream().filter(a -> Name.class.equals(a.annotationType())).findFirst().map(a -> ((Name)a).value()).orElse(null);
        if (sName == null || sName.trim().isEmpty()) {
            Member member = ip.getMember();
            if (member == null) {
                String sMsg = "Cannot determine the name of the semaphore. No @Name qualifier and injection point member is null";
                throw new DefinitionException(sMsg);
            }
            sName = member.getName();
        }
        return sName;
    }

    protected int getPermits(InjectionPoint ip) {
        return ip.getQualifiers().stream().filter(a -> Permits.class.equals(a.annotationType())).findFirst().map(a -> ((Permits)a).value()).orElse(0);
    }
}

