/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent;

import com.oracle.coherence.concurrent.config.ConcurrentServicesSessionConfiguration;
import com.tangosol.internal.net.queue.NamedCacheBlockingDeque;
import com.tangosol.internal.net.queue.NamedCacheDequeBuilder;
import com.tangosol.net.Coherence;
import com.tangosol.net.NamedBlockingDeque;
import com.tangosol.net.NamedBlockingQueue;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.NamedDeque;
import com.tangosol.net.Session;

public class Queues {
    public static final String QUEUE_CACHE_PREFIX = "Queue$";
    public static final String SESSION_NAME = ConcurrentServicesSessionConfiguration.SESSION_NAME;
    public static final NamedCacheDequeBuilder BUILDER = new NamedCacheBlockingDeque.Builder("Queue$");

    public static <E> NamedBlockingDeque<E> blockingDeque(String sName) {
        return Queues.ensureQueue(sName);
    }

    public static <E> NamedBlockingQueue<E> blocking(String sName) {
        return Queues.blockingDeque(sName);
    }

    protected static Session session() {
        return (Session)Coherence.findSession((String)SESSION_NAME).orElseThrow(() -> new IllegalStateException(String.format("The session '%s' has not been initialized", SESSION_NAME)));
    }

    protected static <E> NamedBlockingDeque<E> ensureQueue(String sName) {
        if (sName == null || sName.isEmpty()) {
            sName = "Default";
        }
        Session session = Queues.session();
        NamedDeque deque = session.getDeque(sName, new NamedCollection.Option[]{BUILDER});
        return (NamedBlockingDeque)deque;
    }
}

