/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.atomic;

import com.oracle.coherence.concurrent.atomic.AsyncAtomicInteger;
import com.tangosol.net.AsyncNamedMap;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.function.Remote;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;

public class AsyncRemoteAtomicInteger
implements AsyncAtomicInteger {
    private final AsyncNamedMap<String, AtomicInteger> f_mapAtomic;
    private final String f_sName;

    protected AsyncRemoteAtomicInteger(AsyncNamedMap<String, AtomicInteger> mapAtomic, String sName) {
        this.f_mapAtomic = mapAtomic;
        this.f_sName = sName;
    }

    @Override
    public CompletableFuture<Integer> get() {
        return this.invoke(AtomicInteger::get, false);
    }

    @Override
    public CompletableFuture<Void> set(int nNewValue) {
        return this.invoke((Remote.Function & Serializable)value -> {
            value.set(nNewValue);
            return null;
        });
    }

    @Override
    public CompletableFuture<Integer> getAndSet(int nNewValue) {
        return this.invoke((Remote.Function & Serializable)value -> value.getAndSet(nNewValue));
    }

    @Override
    public CompletableFuture<Boolean> compareAndSet(int nExpectedValue, int nNewValue) {
        return this.invoke((Remote.Function & Serializable)value -> value.compareAndSet(nExpectedValue, nNewValue));
    }

    @Override
    public CompletableFuture<Integer> getAndIncrement() {
        return this.getAndAdd(1);
    }

    @Override
    public CompletableFuture<Integer> getAndDecrement() {
        return this.getAndAdd(-1);
    }

    @Override
    public CompletableFuture<Integer> getAndAdd(int nDelta) {
        return this.invoke((Remote.Function & Serializable)value -> value.getAndAdd(nDelta));
    }

    @Override
    public CompletableFuture<Integer> incrementAndGet() {
        return this.addAndGet(1);
    }

    @Override
    public CompletableFuture<Integer> decrementAndGet() {
        return this.addAndGet(-1);
    }

    @Override
    public CompletableFuture<Integer> addAndGet(int nDelta) {
        return this.invoke((Remote.Function & Serializable)value -> value.addAndGet(nDelta));
    }

    @Override
    public CompletableFuture<Integer> getAndUpdate(Remote.IntUnaryOperator updateFunction) {
        return this.getAndUpdate((IntUnaryOperator)updateFunction);
    }

    @Override
    public CompletableFuture<Integer> getAndUpdate(IntUnaryOperator updateFunction) {
        return this.invoke((Remote.Function & Serializable)value -> value.getAndUpdate(updateFunction));
    }

    @Override
    public CompletableFuture<Integer> updateAndGet(Remote.IntUnaryOperator updateFunction) {
        return this.updateAndGet((IntUnaryOperator)updateFunction);
    }

    @Override
    public CompletableFuture<Integer> updateAndGet(IntUnaryOperator updateFunction) {
        return this.invoke((Remote.Function & Serializable)value -> value.updateAndGet(updateFunction));
    }

    @Override
    public CompletableFuture<Integer> getAndAccumulate(int nUpdate, Remote.IntBinaryOperator accumulatorFunction) {
        return this.getAndAccumulate(nUpdate, (IntBinaryOperator)accumulatorFunction);
    }

    @Override
    public CompletableFuture<Integer> getAndAccumulate(int nUpdate, IntBinaryOperator accumulatorFunction) {
        return this.invoke((Remote.Function & Serializable)value -> value.getAndAccumulate(nUpdate, accumulatorFunction));
    }

    @Override
    public CompletableFuture<Integer> accumulateAndGet(int nUpdate, Remote.IntBinaryOperator accumulatorFunction) {
        return this.accumulateAndGet(nUpdate, (IntBinaryOperator)accumulatorFunction);
    }

    @Override
    public CompletableFuture<Integer> accumulateAndGet(int nUpdate, IntBinaryOperator accumulatorFunction) {
        return this.invoke((Remote.Function & Serializable)value -> value.accumulateAndGet(nUpdate, accumulatorFunction));
    }

    @Override
    public CompletableFuture<Integer> compareAndExchange(int nExpectedValue, int nNewValue) {
        return this.invoke((Remote.Function & Serializable)value -> value.compareAndExchange(nExpectedValue, nNewValue));
    }

    @Override
    public CompletableFuture<Integer> intValue() {
        return this.get();
    }

    @Override
    public CompletableFuture<Long> longValue() {
        return this.get().thenApply(Integer::longValue);
    }

    @Override
    public CompletableFuture<Float> floatValue() {
        return this.get().thenApply(Integer::floatValue);
    }

    @Override
    public CompletableFuture<Double> doubleValue() {
        return this.get().thenApply(Integer::doubleValue);
    }

    @Override
    public CompletableFuture<Byte> byteValue() {
        return this.get().thenApply(Integer::byteValue);
    }

    @Override
    public CompletableFuture<Short> shortValue() {
        return this.get().thenApply(Integer::shortValue);
    }

    public String toString() {
        return Integer.toString(this.get().join());
    }

    protected <R> CompletableFuture<R> invoke(Remote.Function<AtomicInteger, R> function) {
        return this.invoke(function, true);
    }

    protected <R> CompletableFuture<R> invoke(Remote.Function<AtomicInteger, R> function, boolean fMutate) {
        return this.f_mapAtomic.invoke((Object)this.f_sName, (InvocableMap.EntryProcessor & Serializable)entry -> {
            AtomicInteger value = (AtomicInteger)entry.getValue();
            Object result = function.apply((Object)value);
            if (fMutate) {
                entry.setValue((Object)value);
            }
            return result;
        });
    }
}

