/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.TaskProperties;
import com.oracle.coherence.concurrent.executor.util.Caches;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.cache.KeyAssociation;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class ClusteredProperties
implements Task.Properties,
ExternalizableLite,
PortableObject {
    protected String m_sTaskId;
    protected CacheService m_service;

    public ClusteredProperties() {
    }

    public ClusteredProperties(String sTaskId, CacheService service) {
        this.m_sTaskId = sTaskId;
        this.m_service = service;
    }

    public ClusteredProperties(String sTaskId, CacheService service, TaskProperties properties) {
        this.m_sTaskId = sTaskId;
        this.m_service = service;
        NamedCache propertyCache = Caches.properties(service);
        Iterator iterator = properties.getProperties().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            propertyCache.put((Object)new PropertyKey(sTaskId, entry.getKey()), (Object)new PropertyValue(sTaskId, entry.getValue()));
        }
    }

    @Override
    public <V extends Serializable> V get(String sKey) {
        if (this.m_service != null) {
            NamedCache propertyCache = Caches.properties(this.getCacheService());
            PropertyValue value = (PropertyValue)propertyCache.get((Object)new PropertyKey(this.m_sTaskId, sKey));
            return (V)(value == null ? null : (Serializable)value.getValue());
        }
        return null;
    }

    @Override
    public <V extends Serializable> V put(String sKey, V value) {
        if (this.m_service != null) {
            NamedCache propertyCache = Caches.properties(this.getCacheService());
            PropertyValue oldValue = (PropertyValue)propertyCache.put((Object)new PropertyKey(this.m_sTaskId, sKey), (Object)new PropertyValue(this.m_sTaskId, value));
            return (V)(oldValue == null ? null : (Serializable)oldValue.getValue());
        }
        Logger.warn((String)"Failed to put a property; the cache service is null.");
        return null;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_sTaskId = ExternalizableHelper.readUTF((DataInput)in);
        this.m_service = (CacheService)ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_sTaskId);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_service);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_sTaskId = in.readString(0);
        this.m_service = (CacheService)in.readObject(1);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sTaskId);
        out.writeObject(1, (Object)this.m_service);
    }

    protected CacheService getCacheService() {
        return this.m_service;
    }

    public static class PropertyValue
    implements ExternalizableLite,
    PortableObject {
        protected String m_sTaskId;
        protected Object m_oValue;

        public PropertyValue() {
        }

        public PropertyValue(String sTaskId, Object oValue) {
            this.m_sTaskId = sTaskId;
            this.m_oValue = oValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyValue that = (PropertyValue)o;
            if (!Objects.equals(this.m_sTaskId, that.m_sTaskId)) {
                return false;
            }
            return Objects.equals(this.m_oValue, that.m_oValue);
        }

        public int hashCode() {
            int result = this.m_sTaskId != null ? this.m_sTaskId.hashCode() : 0;
            result = 31 * result + (this.m_oValue != null ? this.m_oValue.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.m_sTaskId + ":" + this.m_oValue;
        }

        public String getTaskId() {
            return this.m_sTaskId;
        }

        public Object getValue() {
            return this.m_oValue;
        }

        public void readExternal(DataInput in) throws IOException {
            this.m_sTaskId = ExternalizableHelper.readUTF((DataInput)in);
            this.m_oValue = ExternalizableHelper.readObject((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_sTaskId);
            ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_oValue);
        }

        public void readExternal(PofReader in) throws IOException {
            this.m_sTaskId = in.readString(0);
            this.m_oValue = in.readObject(1);
        }

        public void writeExternal(PofWriter out) throws IOException {
            out.writeString(0, this.m_sTaskId);
            out.writeObject(1, this.m_oValue);
        }
    }

    public static class PropertyKey
    implements ExternalizableLite,
    KeyAssociation,
    PortableObject {
        protected String m_sTaskId;
        protected Object m_oKey;

        public PropertyKey() {
        }

        public PropertyKey(String sTaskId, Object oKey) {
            this.m_sTaskId = sTaskId;
            this.m_oKey = oKey;
        }

        public Object getAssociatedKey() {
            return this.m_sTaskId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyKey that = (PropertyKey)o;
            if (!Objects.equals(this.m_sTaskId, that.m_sTaskId)) {
                return false;
            }
            return Objects.equals(this.m_oKey, that.m_oKey);
        }

        public int hashCode() {
            int result = this.m_sTaskId != null ? this.m_sTaskId.hashCode() : 0;
            result = 31 * result + (this.m_oKey != null ? this.m_oKey.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.m_sTaskId + ":" + this.m_oKey;
        }

        public String getTaskId() {
            return this.m_sTaskId;
        }

        public Object getKey() {
            return this.m_oKey;
        }

        public void readExternal(DataInput in) throws IOException {
            this.m_sTaskId = ExternalizableHelper.readUTF((DataInput)in);
            this.m_oKey = ExternalizableHelper.readObject((DataInput)in);
        }

        public void writeExternal(DataOutput out) throws IOException {
            ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_sTaskId);
            ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_oKey);
        }

        public void readExternal(PofReader in) throws IOException {
            this.m_sTaskId = in.readString(0);
            this.m_oKey = in.readObject(1);
        }

        public void writeExternal(PofWriter out) throws IOException {
            out.writeString(0, this.m_sTaskId);
            out.writeObject(1, this.m_oKey);
        }
    }
}

