/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.function.Predicates;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.function.Remote;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ConditionalCollector<T, A, R>
implements Task.Collector<T, List<T>, R>,
PortableObject {
    protected Remote.Predicate<? super Iterator<T>> m_predicate;
    protected Task.Collector<T, A, R> m_collector;
    protected R m_defaultResult;

    public ConditionalCollector() {
    }

    public ConditionalCollector(Remote.Predicate<? super Iterator<T>> predicate, Task.Collector<? super T, A, R> collector, R defaultResult) {
        this.m_predicate = predicate;
        this.m_collector = collector;
        this.m_defaultResult = defaultResult;
    }

    @Override
    public BiConsumer<List<T>, T> accumulator() {
        return List::add;
    }

    @Override
    public Remote.Predicate<List<T>> finishable() {
        return Predicates.never();
    }

    @Override
    public Function<List<T>, R> finisher() {
        return results -> {
            if (this.m_predicate.test(results.iterator())) {
                A collectorContainer = this.m_collector.supplier().get();
                BiConsumer<A, A> collectorAccumulator = this.m_collector.accumulator();
                Remote.Predicate<A> collectorFinishable = this.m_collector.finishable();
                Function<A, R> collectorFinisher = this.m_collector.finisher();
                Iterator iterator = results.iterator();
                while (iterator.hasNext() && !collectorFinishable.test(collectorContainer)) {
                    Object result = iterator.next();
                    collectorAccumulator.accept(collectorContainer, result);
                }
                return collectorFinisher.apply(collectorContainer);
            }
            return this.m_defaultResult;
        };
    }

    @Override
    public Supplier<List<T>> supplier() {
        return ArrayList::new;
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_predicate = (Remote.Predicate)ExternalizableHelper.readObject((DataInput)in);
        this.m_collector = (Task.Collector)ExternalizableHelper.readObject((DataInput)in);
        this.m_defaultResult = ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, this.m_predicate);
        ExternalizableHelper.writeObject((DataOutput)out, this.m_collector);
        ExternalizableHelper.writeObject((DataOutput)out, this.m_defaultResult);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_predicate = (Remote.Predicate)in.readObject(0);
        this.m_collector = (Task.Collector)in.readObject(1);
        this.m_defaultResult = in.readObject(2);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_predicate);
        out.writeObject(1, this.m_collector);
        out.writeObject(2, this.m_defaultResult);
    }
}

