/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.tasks;

import com.oracle.coherence.concurrent.executor.Task;
import com.oracle.coherence.concurrent.executor.TaskExecutorService;
import com.oracle.coherence.concurrent.executor.util.CronPattern;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Duration;

public class CronTask<T>
implements Task<T>,
PortableObject,
TaskExecutorService.Registration.Option {
    protected Task<T> m_origTask;
    protected Task<T> m_task;
    protected String m_sCronPattern;
    protected long m_ldtNextExecutionMillis;
    protected boolean m_fClone;

    public CronTask() {
    }

    public CronTask(Task<T> task, String sPattern) {
        this(task, sPattern, true);
    }

    public CronTask(Task<T> task, String sPattern, boolean fClone) {
        if (task == null) {
            throw new IllegalArgumentException("Task must be specified");
        }
        if (sPattern == null) {
            throw new IllegalArgumentException("Crontab pattern must be specified");
        }
        this.m_origTask = fClone ? task : null;
        this.m_task = fClone ? (Task)CronTask.clone(task) : task;
        this.m_sCronPattern = sPattern;
        this.m_ldtNextExecutionMillis = 0L;
    }

    public Task<T> getTask() {
        return this.m_task;
    }

    public String getCronPattern() {
        return this.m_sCronPattern;
    }

    public long getNextExecutionMillis(long cMillis) {
        this.m_ldtNextExecutionMillis = new CronPattern(this.m_sCronPattern).getNextExecuteTime(cMillis);
        return this.m_ldtNextExecutionMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T execute(Task.Context<T> context) throws Exception {
        long ldtNextMillis = this.m_ldtNextExecutionMillis;
        long ldtCurrentMillis = System.currentTimeMillis();
        if (ldtNextMillis == 0L) {
            ldtNextMillis = this.getNextExecutionMillis(ldtCurrentMillis);
            throw Task.Yield.atLeast(Duration.ofMillis(ldtNextMillis - ldtCurrentMillis));
        }
        try {
            T result = this.m_task.execute(context);
            context.setResult(result);
            if (this.m_fClone) {
                this.m_task = (Task)CronTask.clone(this.m_origTask);
            }
        }
        finally {
            if (ldtNextMillis < ldtCurrentMillis) {
                ldtNextMillis = this.getNextExecutionMillis(ldtCurrentMillis);
            }
        }
        throw Task.Yield.atLeast(Duration.ofMillis(ldtNextMillis - ldtCurrentMillis));
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_origTask = (Task)ExternalizableHelper.readObject((DataInput)in);
        this.m_task = (Task)ExternalizableHelper.readObject((DataInput)in);
        this.m_sCronPattern = ExternalizableHelper.readUTF((DataInput)in);
        this.m_ldtNextExecutionMillis = ExternalizableHelper.readLong((DataInput)in);
        if (this.m_origTask == null) {
            this.m_fClone = true;
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, this.m_origTask);
        ExternalizableHelper.writeObject((DataOutput)out, this.m_task);
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_sCronPattern);
        ExternalizableHelper.writeLong((DataOutput)out, (long)this.m_ldtNextExecutionMillis);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_origTask = (Task)in.readObject(0);
        this.m_task = (Task)in.readObject(1);
        this.m_sCronPattern = in.readString(2);
        this.m_ldtNextExecutionMillis = in.readLong(3);
        if (this.m_origTask == null) {
            this.m_fClone = true;
        }
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_origTask);
        out.writeObject(1, this.m_task);
        out.writeString(2, this.m_sCronPattern);
        out.writeLong(3, this.m_ldtNextExecutionMillis);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CronTask cronTask = (CronTask)o;
        if (!this.m_origTask.equals(cronTask.m_origTask)) {
            return false;
        }
        return this.m_sCronPattern.equals(cronTask.m_sCronPattern);
    }

    public int hashCode() {
        int result = this.m_task.hashCode();
        result = 31 * result + this.m_sCronPattern.hashCode();
        return result;
    }

    public String toString() {
        return "CronTask{task=" + this.m_task + "cron-pattern=" + this.m_sCronPattern + "}";
    }

    public static Object clone(Object object) {
        return ExternalizableHelper.fromBinary((Binary)ExternalizableHelper.toBinary((Object)object));
    }

    public static <T> CronTask<T> of(Task<T> task, String sCronPattern) {
        return new CronTask<T>(task, sCronPattern);
    }

    public static <T> CronTask<T> of(Task<T> task, String sCronPattern, boolean fClone) {
        return new CronTask<T>(task, sCronPattern, fClone);
    }
}

