/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.internal;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.concurrent.config.ConcurrentConfiguration;
import com.oracle.coherence.concurrent.executor.ClusteredAssignment;
import com.oracle.coherence.concurrent.executor.ClusteredExecutorService;
import com.oracle.coherence.concurrent.executor.internal.ExecutorTrace;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.events.EventInterceptor;
import com.tangosol.net.events.application.LifecycleEvent;
import com.tangosol.util.Base;
import com.tangosol.util.ResourceRegistry;

public class LifecycleEventInterceptor
implements EventInterceptor<LifecycleEvent> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onEvent(LifecycleEvent event) {
        ExecutorTrace.log(() -> String.format("LifecycleEventInterceptor received event with type: %s", event.getType()));
        if (event.getType() == LifecycleEvent.Type.ACTIVATED) {
            try {
                Member member = CacheFactory.getCluster().getLocalMember();
                ConfigurableCacheFactory configurableCacheFactory = event.getConfigurableCacheFactory();
                NamedCache cache = configurableCacheFactory.ensureCache(ClusteredAssignment.CACHE_NAME, null);
                if (cache != null && cache.isActive()) {
                    CacheService service = cache.getCacheService();
                    if (service != null && service.isRunning()) {
                        Logger.info(() -> String.format("Establishing Executor for Member [%s] with the ClusteredExecutorService", member.getId()));
                        ClusteredExecutorService clusteredExecutorService = new ClusteredExecutorService(service);
                        ResourceRegistry ccfRegistry = configurableCacheFactory.getResourceRegistry();
                        ccfRegistry.registerResource(ClusteredExecutorService.class, ClusteredExecutorService.class.getSimpleName(), (Object)clusteredExecutorService);
                        ConcurrentConfiguration configuration = ConcurrentConfiguration.get();
                        configuration.setExecutorService(clusteredExecutorService);
                        return;
                    }
                    if (!Logger.isEnabled((int)2)) return;
                    String sMsg = "Unable to establishing Executor for Member [%s] with the ClusteredExecutorService; the cache service does not exist or is not running.";
                    Logger.warn((String)String.format(sMsg, member.getId()));
                    return;
                }
                if (!Logger.isEnabled((int)2)) return;
                String sMsg = "Unable to establishing Executor for Member [%s] with the ClusteredExecutorService; the cache does not exist or is not active.";
                Logger.warn((String)String.format(sMsg, member.getId()));
                return;
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException((Throwable)e);
            }
        } else {
            if (event.getType() != LifecycleEvent.Type.DISPOSING) return;
            ResourceRegistry registry = event.getConfigurableCacheFactory().getResourceRegistry();
            ClusteredExecutorService clusteredExecutorService = (ClusteredExecutorService)registry.getResource(ClusteredExecutorService.class, ClusteredExecutorService.class.getSimpleName());
            if (clusteredExecutorService != null) {
                clusteredExecutorService.shutdownNow();
            }
            ConcurrentConfiguration.get().reset();
        }
    }
}

