/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor;

import com.oracle.coherence.concurrent.executor.AbstractOrchestration;
import com.oracle.coherence.concurrent.executor.Task;
import com.tangosol.util.function.Remote;
import java.util.LinkedHashSet;

public abstract class AbstractCollectable<T, R, O extends AbstractOrchestration<T, ?>>
implements Task.Collectable<T, R>,
Task.Completable<T, R> {
    protected O m_orchestration;
    protected Task.Collector<? super T, ?, R> m_collector;
    protected Remote.Predicate<? super R> m_completionPredicate;
    protected LinkedHashSet<Task.Subscriber<? super R>> m_setSubscribers;
    protected Task.CompletionRunnable<? super R> m_completionRunnable;

    public AbstractCollectable(O orchestration, Task.Collector<? super T, ?, R> collector) {
        this.m_orchestration = orchestration;
        this.m_collector = collector;
        this.m_setSubscribers = new LinkedHashSet();
    }

    @Override
    public Task.Completable<T, R> until(Remote.Predicate<? super R> predicate) {
        this.m_completionPredicate = predicate;
        return this;
    }

    @Override
    public Task.Completable<T, R> andThen(Task.CompletionRunnable<? super R> runnable) {
        this.m_completionRunnable = runnable;
        return this;
    }

    @Override
    public Task.Collectable<T, R> subscribe(Task.Subscriber<? super R> subscriber) {
        this.m_setSubscribers.add(subscriber);
        return this;
    }
}

