/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.internal;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LatchCounter
implements ExternalizableLite,
PortableObject {
    protected long m_lCount;
    protected long f_lInitialCount;

    public LatchCounter() {
    }

    public LatchCounter(int count) {
        this.m_lCount = count;
        this.f_lInitialCount = count;
    }

    public long getCount() {
        return this.m_lCount;
    }

    public long getInitialCount() {
        return this.f_lInitialCount;
    }

    public void countDown() {
        if (this.m_lCount > 0L) {
            --this.m_lCount;
        }
    }

    public String toString() {
        return "LatchCounter{count=" + this.m_lCount + ", initialCount=" + this.f_lInitialCount + "}";
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_lCount = in.readLong();
        this.f_lInitialCount = in.readLong();
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeLong(this.m_lCount);
        out.writeLong(this.f_lInitialCount);
    }

    public void readExternal(PofReader in) throws IOException {
        this.m_lCount = in.readLong(1);
        this.f_lInitialCount = in.readLong(2);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(1, this.m_lCount);
        out.writeLong(2, this.f_lInitialCount);
    }
}

