/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.concurrent.executor.subscribers.internal;

import com.oracle.coherence.concurrent.executor.Result;
import com.oracle.coherence.concurrent.executor.Task;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FutureSubscriber<T>
implements Future<T>,
Task.Subscriber<T> {
    protected Task.Coordinator<T> m_coordinator;
    protected final AtomicBoolean f_fCompleted = new AtomicBoolean(false);
    protected final AtomicBoolean f_fError = new AtomicBoolean(false);
    protected Result<T> m_result = Result.none();
    private final AtomicReference<Task.Subscription> f_subscription = new AtomicReference();

    public void setCoordinator(Task.Coordinator<T> coordinator) {
        this.m_coordinator = coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onComplete() {
        this.f_fCompleted.compareAndSet(false, true);
        this.f_subscription.set(null);
        FutureSubscriber futureSubscriber = this;
        synchronized (futureSubscriber) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable throwable) {
        this.f_fError.compareAndSet(false, true);
        this.f_subscription.set(null);
        this.m_result = Result.throwable(throwable);
        FutureSubscriber futureSubscriber = this;
        synchronized (futureSubscriber) {
            this.notifyAll();
        }
    }

    @Override
    public void onNext(T result) {
        this.m_result = Result.of(result);
    }

    @Override
    public void onSubscribe(Task.Subscription subscription) {
        if (!this.f_subscription.compareAndSet(null, subscription)) {
            throw new UnsupportedOperationException("FutureSubscriber reuse is not supported.");
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Task.Coordinator<T> coordinator = this.m_coordinator;
        return !this.isDone() && coordinator != null && coordinator.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.m_coordinator.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.f_fCompleted.get() || this.f_fError.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (!this.hasResult()) {
            FutureSubscriber futureSubscriber = this;
            synchronized (futureSubscriber) {
                this.wait();
            }
        }
        try {
            return this.m_result.get();
        }
        catch (Throwable throwable) {
            throw new ExecutionException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (timeout > 0L && !this.hasResult()) {
            FutureSubscriber futureSubscriber = this;
            synchronized (futureSubscriber) {
                this.wait(unit.toMillis(timeout));
            }
            if (!this.hasResult()) {
                throw new TimeoutException("Timed out before the task is completed.");
            }
        }
        try {
            return this.m_result.get();
        }
        catch (Throwable throwable) {
            throw new ExecutionException(throwable);
        }
    }

    public boolean getCompleted() {
        return this.f_fCompleted.get();
    }

    public boolean hasResult() {
        return this.m_result.isPresent();
    }

    public boolean isSubscribed() {
        return this.f_subscription.get() != null;
    }
}

