/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.cdi.server;

import com.oracle.coherence.cdi.Name;
import com.oracle.coherence.cdi.Scope;
import com.oracle.coherence.cdi.SubscriberGroup;
import com.oracle.coherence.cdi.server.ConfigurableCacheFactoryProducer;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.net.topic.Publisher;
import com.tangosol.net.topic.Subscriber;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@ApplicationScoped
class NamedTopicProducer {
    private final ConfigurableCacheFactoryProducer m_cacheFactoryProducer;

    @Inject
    NamedTopicProducer(ConfigurableCacheFactoryProducer cacheFactoryProducer) {
        this.m_cacheFactoryProducer = cacheFactoryProducer;
    }

    @Produces
    <V> NamedTopic<V> getNonQualifiedNamedTopic(InjectionPoint injectionPoint) {
        return this.getNamedTopic(injectionPoint);
    }

    @Produces
    @Name(value="")
    @Scope(value="")
    <V> NamedTopic<V> getNamedTopic(InjectionPoint injectionPoint) {
        String sName = null;
        String sSession = null;
        for (Annotation annotation : injectionPoint.getQualifiers()) {
            if (Name.class.equals(annotation.annotationType())) {
                sName = ((Name)annotation).value();
                continue;
            }
            if (!Scope.class.equals(annotation.annotationType())) continue;
            sSession = ((Scope)annotation).value();
        }
        if (sName == null) {
            sName = injectionPoint.getMember().getName();
        }
        ConfigurableCacheFactory ccf = this.m_cacheFactoryProducer.getConfigurableCacheFactory(sSession, injectionPoint);
        return ccf.ensureTopic(sName, new NamedCollection.Option[0]);
    }

    @Produces
    <V> Publisher<V> getNonQualifiedNamedTopicPublisher(InjectionPoint injectionPoint) {
        return this.getNamedTopicPublisher(injectionPoint);
    }

    @Produces
    @Name(value="")
    @Scope(value="")
    <V> Publisher<V> getNamedTopicPublisher(InjectionPoint injectionPoint) {
        NamedTopic<V> topic = this.getNamedTopic(injectionPoint);
        return topic.createPublisher();
    }

    <V> void closePublisher(@Disposes Publisher<V> publisher) {
        publisher.close();
    }

    <V> void closeQualifiedPublisher(@Disposes @Name(value="") @Scope(value="") Publisher<V> publisher) {
        publisher.close();
    }

    @Produces
    <V> Subscriber<V> getNonQualifiedNamedTopicSubscriber(InjectionPoint injectionPoint) {
        return this.getNamedTopicSubscriber(injectionPoint);
    }

    @Produces
    @Name(value="")
    @Scope(value="")
    <V> Subscriber<V> getNamedTopicSubscriber(InjectionPoint injectionPoint) {
        String sGroup = injectionPoint.getQualifiers().stream().filter(q -> SubscriberGroup.class.isAssignableFrom(q.getClass())).map(q -> ((SubscriberGroup)q).value()).findFirst().orElse(null);
        NamedTopic<V> topic = this.getNamedTopic(injectionPoint);
        return sGroup == null ? topic.createSubscriber() : topic.createSubscriber(new Subscriber.Option[]{Subscriber.Name.of((String)sGroup)});
    }

    <V> void closeSubscriber(@Disposes Subscriber<V> subscriber) {
        subscriber.close();
    }

    <V> void closeQualifiedSubscriber(@Disposes @Name(value="") @Scope(value="") Subscriber<V> subscriber) {
        subscriber.close();
    }
}

