/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.testsupport.deferred;

import com.oracle.bedrock.deferred.Deferred;
import com.oracle.bedrock.deferred.Existing;
import com.oracle.bedrock.deferred.PermanentlyUnavailableException;
import com.oracle.bedrock.deferred.TemporarilyUnavailableException;
import com.oracle.bedrock.deferred.UnavailableException;
import com.oracle.bedrock.testsupport.matchers.ThrowableMatcher;
import org.hamcrest.Matcher;

public class DeferredMatch<T>
implements Deferred<Boolean> {
    private Deferred<T> deferred;
    private Matcher<? super T> matcher;
    private T lastUsedMatchValue;

    public DeferredMatch(Deferred<T> deferred, Matcher<? super T> matcher) {
        this.deferred = deferred;
        this.matcher = matcher;
        this.lastUsedMatchValue = null;
    }

    public Deferred<T> getDeferred() {
        return this.deferred;
    }

    public Matcher<? super T> getMatcher() {
        return this.matcher;
    }

    public T getLastUsedMatchValue() {
        return this.lastUsedMatchValue;
    }

    public Boolean get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
        try {
            this.lastUsedMatchValue = this.deferred.get();
            if (this.matcher instanceof ThrowableMatcher) {
                throw new TemporarilyUnavailableException((Deferred)this);
            }
            if (this.matcher.matches(this.lastUsedMatchValue)) {
                return true;
            }
            if (this.deferred instanceof Existing) {
                throw new PermanentlyUnavailableException((Deferred)this);
            }
            throw new TemporarilyUnavailableException((Deferred)this);
        }
        catch (UnavailableException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (this.matcher instanceof ThrowableMatcher) {
                ThrowableMatcher throwableMatcher = (ThrowableMatcher)this.matcher;
                return throwableMatcher.getMatcher().matches((Object)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (this.matcher instanceof ThrowableMatcher) {
                ThrowableMatcher throwableMatcher = (ThrowableMatcher)this.matcher;
                return throwableMatcher.getMatcher().matches((Object)e);
            }
            throw new PermanentlyUnavailableException((Deferred)this, (Throwable)e);
        }
    }

    public Class<Boolean> getDeferredClass() {
        return Boolean.class;
    }

    public String toString() {
        return String.format("DeferredMatch{deferred=%s, matcher=%s, lastUsedMatchValue=%s}", this.deferred, this.matcher, this.lastUsedMatchValue);
    }
}

