/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect;

import com.optimaize.langdetect.profiles.LanguageProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NgramFrequencyData {
    @NotNull
    private final Map<String, double[]> wordLangProbMap;
    @NotNull
    private final List<String> langlist;

    @NotNull
    public static NgramFrequencyData create(@NotNull Collection<LanguageProfile> languageProfiles, @NotNull Collection<Integer> gramLengths) throws IllegalArgumentException {
        if (languageProfiles.isEmpty()) {
            throw new IllegalArgumentException("No languageProfiles provided!");
        }
        if (gramLengths.isEmpty()) {
            throw new IllegalArgumentException("No gramLengths provided!");
        }
        HashMap<String, double[]> wordLangProbMap = new HashMap<String, double[]>();
        ArrayList<String> langlist = new ArrayList<String>();
        int langsize = languageProfiles.size();
        int index = -1;
        for (LanguageProfile profile : languageProfiles) {
            ++index;
            langlist.add(profile.getLanguage());
            for (Integer gramLength : gramLengths) {
                if (!profile.getGramLengths().contains(gramLength)) {
                    throw new IllegalArgumentException("The language profile for " + profile.getLanguage() + " does not contain " + gramLength + "-grams!");
                }
                for (Map.Entry<String, Integer> ngramEntry : profile.iterateGrams(gramLength)) {
                    double prob;
                    String ngram = ngramEntry.getKey();
                    Integer frequency = ngramEntry.getValue();
                    if (!wordLangProbMap.containsKey(ngram)) {
                        wordLangProbMap.put(ngram, new double[langsize]);
                    }
                    ((double[])wordLangProbMap.get((Object)ngram))[index] = prob = frequency.doubleValue() / (double)profile.getNumGramOccurrences(ngram.length());
                }
            }
        }
        return new NgramFrequencyData(wordLangProbMap, langlist);
    }

    private NgramFrequencyData(@NotNull Map<String, double[]> wordLangProbMap, @NotNull List<String> langlist) {
        this.wordLangProbMap = Collections.unmodifiableMap(wordLangProbMap);
        this.langlist = Collections.unmodifiableList(langlist);
    }

    @NotNull
    public List<String> getLanguageList() {
        return this.langlist;
    }

    @NotNull
    public String getLanguage(int pos) {
        return this.langlist.get(pos);
    }

    @Nullable
    public double[] getProbabilities(String ngram) {
        return this.wordLangProbMap.get(ngram);
    }
}

