/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import be.frma.langguess.IOUtils;
import be.frma.langguess.LangProfileWriter;
import com.cybozu.labs.langdetect.GenProfile;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.util.LangProfile;
import com.google.common.base.Optional;
import com.optimaize.langdetect.DetectedLanguage;
import com.optimaize.langdetect.LanguageDetector;
import com.optimaize.langdetect.LanguageDetectorBuilder;
import com.optimaize.langdetect.ngram.NgramExtractors;
import com.optimaize.langdetect.profiles.LanguageProfile;
import com.optimaize.langdetect.profiles.LanguageProfileReader;
import com.optimaize.langdetect.text.CommonTextObjectFactories;
import com.optimaize.langdetect.text.TextObject;
import com.optimaize.langdetect.text.TextObjectFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandLineInterface {
    private static final double DEFAULT_ALPHA = 0.5;
    private Map<String, String> opt_with_value = new HashMap<String, String>();
    private Map<String, String> values = new HashMap<String, String>();
    private Set<String> opt_without_value = new HashSet<String>();
    private List<String> arglist = new ArrayList<String>();

    public static void main(String[] args) throws IOException {
        CommandLineInterface cli = new CommandLineInterface();
        cli.addOpt("-d", "directory", "./");
        cli.addOpt("-a", "alpha", "0.5");
        cli.parse(args);
        if (cli.hasOpt("--genprofile")) {
            cli.generateProfile();
        } else if (cli.hasOpt("--detectlang")) {
            cli.detectLang();
        } else if (cli.hasOpt("--batchtest")) {
            cli.batchTest();
        }
    }

    private void parse(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (this.opt_with_value.containsKey(args[i])) {
                String key = this.opt_with_value.get(args[i]);
                this.values.put(key, args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].startsWith("-")) {
                this.opt_without_value.add(args[i]);
                continue;
            }
            this.arglist.add(args[i]);
        }
    }

    private void addOpt(String opt, String key, String value) {
        this.opt_with_value.put(opt, key);
        this.values.put(key, value);
    }

    private String get(String key) {
        return this.values.get(key);
    }

    private Long getLong(String key) {
        String value = this.values.get(key);
        if (value == null) {
            return null;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private double getDouble(String key, double defaultValue) {
        try {
            return Double.valueOf(this.values.get(key));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private boolean hasOpt(String opt) {
        return this.opt_without_value.contains(opt);
    }

    private File searchFile(File directory, String pattern) {
        for (File file : directory.listFiles()) {
            if (!file.getName().matches(pattern)) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateProfile() {
        String lang;
        File directory = new File(this.arglist.get(0));
        File file = this.searchFile(directory, (lang = this.arglist.get(1)) + "wiki-.*-abstract\\.xml.*");
        if (file == null) {
            System.err.println("Not Found text file : lang = " + lang);
            return;
        }
        Closeable os = null;
        try {
            LangProfile profile = GenProfile.load(lang, file);
            profile.omitLessFreq();
            new LangProfileWriter().write(profile, new FileOutputStream(new File(lang)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LangDetectException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(os);
        }
    }

    public void detectLang() throws IOException {
        LanguageDetector languageDetector = this.makeDetector();
        TextObjectFactory textObjectFactory = CommonTextObjectFactories.forDetectingOnLargeText();
        for (String filename : this.arglist) {
            BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));
            Throwable throwable = null;
            try {
                TextObject textObject = textObjectFactory.create().append(is);
                List<DetectedLanguage> probabilities = languageDetector.getProbabilities(textObject);
                System.out.println(filename + ":" + probabilities);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    public void batchTest() throws IOException {
        LanguageDetector languageDetector = this.makeDetector();
        TextObjectFactory textObjectFactory = CommonTextObjectFactories.forDetectingOnLargeText();
        HashMap result = new HashMap();
        for (String filename : this.arglist) {
            try (BufferedReader is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "utf-8"));){
                while (is.ready()) {
                    String line = is.readLine();
                    int idx = line.indexOf(9);
                    if (idx <= 0) continue;
                    String correctLang = line.substring(0, idx);
                    String text = line.substring(idx + 1);
                    TextObject textObject = textObjectFactory.forText(text);
                    Optional<String> lang = languageDetector.detect(textObject);
                    if (!result.containsKey(correctLang)) {
                        result.put(correctLang, new ArrayList());
                    }
                    ((List)result.get(correctLang)).add(lang.or((Object)"unknown"));
                    if (!this.hasOpt("--debug")) continue;
                    System.out.println(correctLang + "," + lang + "," + (text.length() > 100 ? text.substring(0, 100) : text));
                }
            }
            ArrayList langlist = new ArrayList(result.keySet());
            Collections.sort(langlist);
            int totalCount = 0;
            int totalCorrect = 0;
            for (String lang : langlist) {
                HashMap<String, Integer> resultCount = new HashMap<String, Integer>();
                int count = 0;
                List list = (List)result.get(lang);
                for (String detectedLang : list) {
                    ++count;
                    if (resultCount.containsKey(detectedLang)) {
                        resultCount.put(detectedLang, (Integer)resultCount.get(detectedLang) + 1);
                        continue;
                    }
                    resultCount.put(detectedLang, 1);
                }
                int correct = resultCount.containsKey(lang) ? (Integer)resultCount.get(lang) : 0;
                double rate = (double)correct / (double)count;
                System.out.println(String.format("%s (%d/%d=%.2f): %s", lang, correct, count, rate, resultCount));
                totalCorrect += correct;
                totalCount += count;
            }
            System.out.println(String.format("total: %d/%d = %.3f", totalCorrect, totalCount, (double)totalCorrect / (double)totalCount));
        }
    }

    private LanguageDetector makeDetector() throws IOException {
        double alpha = this.getDouble("alpha", 0.5);
        String profileDirectory = this.get("directory") + "/";
        List<LanguageProfile> languageProfiles = new LanguageProfileReader().readAll(new File(profileDirectory));
        return LanguageDetectorBuilder.create(NgramExtractors.standard()).alpha(alpha).shortTextAlgorithm(50).withProfiles(languageProfiles).build();
    }
}

