/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.messages.desktop;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.scope.Message;
import java.util.Map;

public enum SystemInputMessage implements Message
{
    CLICK(1),
    KEYPRESS(2),
    KEYUP(3),
    KEYDOWN(4),
    MOUSEDOWN(5),
    MOUSEUP(6),
    MOUSEMOVE(7),
    DEFAULT(-1);

    private static final Map<Integer, SystemInputMessage> lookup;
    private final int code;

    private SystemInputMessage(int code) {
        this.code = code;
    }

    @Override
    public int getID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "system-input";
    }

    public static SystemInputMessage get(int code) {
        SystemInputMessage command = lookup.get(code);
        return command != null ? command : DEFAULT;
    }

    static {
        lookup = Maps.uniqueIndex((Iterable)ImmutableList.copyOf((Object[])SystemInputMessage.values()), (Function)new Function<SystemInputMessage, Integer>(){

            public Integer apply(SystemInputMessage message) {
                return message.getID();
            }
        });
    }
}

