/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp.services.messages.desktop;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.opera.core.systems.scope.Message;
import java.util.Map;

public enum DesktopWindowManagerMessage implements Message
{
    GET_ACTIVE_WINDOW(1),
    LIST_WINDOWS(2),
    LIST_QUICK_WIDGETS(3),
    GET_QUICK_WIDGET(4),
    WINDOW_SHOWN(5),
    WINDOW_UPDATED(6),
    WINDOW_CLOSED(7),
    WINDOW_ACTIVATED(8),
    WINDOW_LOADED(9),
    LIST_QUICK_MENUS(10),
    MENU_SHOWN(11),
    MENU_CLOSED(12),
    PRESS_QUICK_MENU(13),
    MENU_PRESSED(14),
    WINDOW_PAGE_CHANGED(15),
    DEFAULT(-1);

    private static final Map<Integer, DesktopWindowManagerMessage> lookup;
    private final int code;

    private DesktopWindowManagerMessage(int code) {
        this.code = code;
    }

    @Override
    public int getID() {
        return this.code;
    }

    @Override
    public String getServiceName() {
        return "desktop-window-manager";
    }

    public static DesktopWindowManagerMessage get(int code) {
        DesktopWindowManagerMessage message = lookup.get(code);
        return message != null ? message : DEFAULT;
    }

    static {
        lookup = Maps.uniqueIndex((Iterable)ImmutableList.copyOf((Object[])DesktopWindowManagerMessage.values()), (Function)new Function<DesktopWindowManagerMessage, Integer>(){

            public Integer apply(DesktopWindowManagerMessage message) {
                return message.getID();
            }
        });
    }
}

