/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.common.io;

import java.util.logging.Logger;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.CommandLine;

public final class ProcessManager {
    private static final Platform currentPlatform = Platform.getCurrent();
    private static final Logger logger = Logger.getLogger(ProcessManager.class.getName());

    public static boolean isPidRunning(int processID) {
        String output;
        if (currentPlatform.is(Platform.WINDOWS)) {
            output = ProcessManager.executeCommand("tasklist", "/FI", String.format("\"PID eq %d\"", processID));
        } else if (currentPlatform.is(Platform.UNIX) || currentPlatform.is(Platform.MAC)) {
            output = ProcessManager.executeCommand("ps", "-p", String.valueOf(processID));
        } else {
            throw new WebDriverException("Unknown platform: " + currentPlatform);
        }
        return output != null && output.contains(String.format("%d ", processID));
    }

    public static void killPID(int processID) {
        if (currentPlatform.is(Platform.WINDOWS)) {
            ProcessManager.executeCommand("taskkill", "/pid", String.valueOf(processID));
        } else if (currentPlatform.is(Platform.UNIX) || currentPlatform.is(Platform.MAC)) {
            ProcessManager.executeCommand("kill", "-SIGKILL", String.valueOf(processID));
        } else {
            throw new WebDriverException("Unknown platform: " + currentPlatform);
        }
    }

    private static String executeCommand(String commandName, String ... args) {
        CommandLine cmd = new CommandLine(commandName, args);
        logger.fine(cmd.toString());
        cmd.execute();
        String output = cmd.getStdOut();
        if (!cmd.isSuccessful()) {
            throw new WebDriverException(String.format("exec return code %d: %s", cmd.getExitCode(), output));
        }
        return output;
    }
}

