/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.util;

import com.opera.core.systems.settings.OperaDriverSettings;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Capabilities;

public class ProfileUtils {
    private String largePrefsFolder;
    private String smallPrefsFolder;
    private String cachePrefsFolder;
    private Capabilities capabilities;

    @Deprecated
    public ProfileUtils(String largePrefsFolder, String smallPrefsFolder, String cachePrefsFolder, OperaDriverSettings settings) {
        this(largePrefsFolder, smallPrefsFolder, cachePrefsFolder, settings.getCapabilities());
    }

    public ProfileUtils(String largePrefsFolder, String smallPrefsFolder, String cachePrefsFolder, Capabilities capabilities) {
        this.capabilities = capabilities;
        this.largePrefsFolder = largePrefsFolder;
        this.smallPrefsFolder = smallPrefsFolder;
        this.cachePrefsFolder = cachePrefsFolder;
    }

    public boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    public boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public boolean isMainProfile(String prefsPath) {
        File prefsFile = new File(prefsPath);
        String absolutePrefsPath = prefsFile.getAbsolutePath();
        String path = System.getProperty("user.home");
        if (this.isMac()) {
            File appSupport = new File(path + "/Library/Application Support/Opera");
            File cache = new File(path + "/Library/Caches/Opera");
            File prefs = new File(path + "/Library/Preferences/Opera Preference");
            if (absolutePrefsPath.startsWith(appSupport.getAbsolutePath()) || absolutePrefsPath.startsWith(cache.getAbsolutePath()) || absolutePrefsPath.startsWith(prefs.getAbsolutePath())) {
                return true;
            }
        } else if (this.isWindows()) {
            String appData = System.getenv("APPDATA");
            File appFile = new File(appData + "\\Opera");
            if (absolutePrefsPath.startsWith(appFile.getAbsolutePath())) {
                return true;
            }
            String homeDrive = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            File homeOpera = new File(homeDrive + homePath + "\\Local Settings\\Application Data\\Opera");
            if (absolutePrefsPath.startsWith(homeOpera.getAbsolutePath())) {
                return true;
            }
            String localAppData = System.getenv("LOCALAPPDATA");
            File localAppDataFile = new File(localAppData + "\\Opera");
            if (absolutePrefsPath.startsWith(localAppDataFile.getAbsolutePath())) {
                return true;
            }
            File exeFile = new File((String)this.capabilities.getCapability("opera.binary"));
            String parentPath = exeFile.getParent();
            File profileFolder = new File(parentPath + "\\profile");
            if (prefsFile.equals(profileFolder)) {
                return true;
            }
        } else {
            File dotOpera = new File(path + "/.opera");
            if (prefsFile.equals(dotOpera)) {
                return true;
            }
        }
        return false;
    }

    public boolean deleteProfile() {
        if (this.isMainProfile(this.smallPrefsFolder) || this.isMainProfile(this.largePrefsFolder) || this.isMainProfile(this.cachePrefsFolder)) {
            return false;
        }
        boolean deleted = this.deleteFolder(this.smallPrefsFolder);
        if (deleted && !this.smallPrefsFolder.equals(this.largePrefsFolder)) {
            deleted = this.deleteFolder(this.largePrefsFolder);
        }
        if (deleted && !this.smallPrefsFolder.equals(this.cachePrefsFolder) && !this.largePrefsFolder.equals(this.cachePrefsFolder)) {
            deleted = this.deleteFolder(this.cachePrefsFolder);
        }
        return deleted;
    }

    public boolean copyProfile(String newPrefs) {
        if (!new File(newPrefs).exists()) {
            return false;
        }
        try {
            FileUtils.copyDirectory((File)new File(newPrefs), (File)new File(this.smallPrefsFolder));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean deleteFolder(String folderPath) {
        return FileUtils.deleteQuietly((File)new File(folderPath));
    }
}

