/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.stp;

import com.opera.core.systems.scope.handlers.AbstractEventHandler;
import com.opera.core.systems.scope.handlers.IConnectionHandler;
import com.opera.core.systems.scope.stp.StpConnection;
import com.opera.core.systems.util.SocketListener;
import com.opera.core.systems.util.SocketMonitor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;

public class StpConnectionListener
implements SocketListener {
    private int port;
    private ServerSocketChannel server = null;
    private IConnectionHandler handler;
    private AbstractEventHandler eventHandler;
    private boolean manualConnect = false;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private SocketMonitor monitor;

    public StpConnectionListener(int port, IConnectionHandler handler, AbstractEventHandler eventHandler, boolean manualConnect, SocketMonitor monitor) throws IOException {
        this.port = port;
        this.handler = handler;
        this.eventHandler = eventHandler;
        this.manualConnect = manualConnect;
        this.monitor = monitor;
        this.start();
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.server == null) {
            return;
        }
        this.logger.fine("Shutting down STP connection listener");
        this.monitor.remove(this.server);
        try {
            this.server.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.server = null;
        }
    }

    public void start() throws IOException {
        this.server = ServerSocketChannel.open();
        this.server.configureBlocking(false);
        this.server.socket().setReuseAddress(true);
        this.server.socket().bind(new InetSocketAddress(this.port));
        this.monitor.add(this.server, this, 16);
        if (this.manualConnect) {
            System.out.println("Ready to accept connections on port " + this.port);
        }
    }

    public boolean canRead(SelectableChannel channel) throws IOException {
        if (!this.server.isOpen()) {
            return false;
        }
        SocketChannel socket = this.server.accept();
        if (socket != null) {
            this.logger.fine("Accepted connection from " + socket.socket().getLocalAddress());
            socket.socket().setTcpNoDelay(true);
            new StpConnection(socket, this.handler, this.eventHandler, this.monitor);
        }
        return true;
    }

    public boolean canWrite(SelectableChannel ch) throws IOException {
        return false;
    }
}

