/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.OperaWebElement;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.model.ScriptResult;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.ESCommand;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.protos.EcmascriptProtos;
import com.opera.core.systems.scope.protos.EsdbgProtos;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.services.IEcmaScriptDebugger;
import com.opera.core.systems.scope.services.IWindowManager;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcmascriptService
extends AbstractService
implements IEcmaScriptDebugger {
    private AtomicStampedReference<EcmascriptProtos.Runtime> runtime = new AtomicStampedReference<Object>(null, 0);
    private IWindowManager windowManager;
    private int retries;
    private long sleepDuration;
    protected int activeWindowId;
    private Queue<Integer> runtimesQueue = new LinkedList<Integer>();
    private Queue<Integer> garbageQueue = new LinkedList<Integer>();
    private ConcurrentMap<Integer, EcmascriptProtos.Runtime> runtimesList = new ConcurrentHashMap<Integer, EcmascriptProtos.Runtime>();
    protected OperaDriver driver;

    public EcmascriptService(ScopeServices services, String version) {
        super(services, version);
        services.setDebugger(this);
        this.windowManager = services.getWindowManager();
        this.services = services;
        this.resetCounters();
    }

    @Override
    public void setDriver(OperaDriver driver) {
        this.driver = driver;
    }

    private void resetCounters() {
        this.retries = 0;
        this.sleepDuration = OperaIntervals.SCRIPT_RETRY_INTERVAL.getValue();
    }

    @Override
    public void addRuntime(EsdbgProtos.RuntimeInfo info) {
        throw new UnsupportedOperationException("Not suppported without ecmascript-debugger");
    }

    private UmsProtos.Response eval(String using, EcmascriptProtos.EvalArg.Variable ... variables) {
        if (this.windowManager.getActiveWindowId() != this.activeWindowId) {
            this.recover();
        }
        this.processQueues();
        EcmascriptProtos.EvalArg.Builder builder = this.buildEval(using);
        builder.addAllVariableList(Arrays.asList(variables));
        UmsProtos.Response response = this.executeCommand(ESCommand.EVAL, (AbstractMessage.Builder<?>)builder);
        if (response == null && (long)this.retries < OperaIntervals.SCRIPT_RETRY.getValue()) {
            ++this.retries;
            this.sleepDuration += this.sleepDuration;
            EcmascriptService.sleep(this.sleepDuration);
            this.recover();
            return this.eval(using, variables);
        }
        if ((long)this.retries >= OperaIntervals.SCRIPT_RETRY.getValue()) {
            this.resetCounters();
            throw new WebDriverException("Internal error");
        }
        this.resetCounters();
        return response;
    }

    private void recover() {
        this.windowManager.findDriverWindow();
        this.activeWindowId = this.windowManager.getActiveWindowId();
        this.updateRuntime();
    }

    @Override
    public String callFunctionOnObject(String using, int objectId) {
        Object result = this.callFunctionOnObject(using, objectId, true);
        return result == null ? null : String.valueOf(result);
    }

    @Override
    public Object callFunctionOnObject(String using, int objectId, boolean responseExpected) {
        EcmascriptProtos.EvalArg.Variable variable = this.buildVariable("locator", objectId);
        UmsProtos.Response response = this.eval(using, variable);
        return responseExpected ? this.parseEvalReply(this.parseEvalData(response)) : null;
    }

    private Object parseEvalReply(EcmascriptProtos.EvalResult result) {
        EcmascriptProtos.EvalResult.Status status = result.getStatus();
        switch (status) {
            case CANCELLED: {
                return null;
            }
            case EXCEPTION: {
                throw new WebDriverException("Ecmascript exception");
            }
            case NO_MEMORY: {
                throw new WebDriverException("Out of memory");
            }
            case FAILURE: {
                throw new WebDriverException("Could not execute script");
            }
        }
        EcmascriptProtos.Value value = result.getValue();
        EcmascriptProtos.Value.Type type = value.getType();
        switch (type) {
            case STRING: {
                return value.getStr();
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case OBJECT: {
                return value.getObject();
            }
            case NUMBER: {
                return this.parseNumber(String.valueOf(value.getNumber()));
            }
            case NAN: {
                return Float.valueOf(Float.NaN);
            }
            case MINUS_INFINITY: {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
            case PLUS_INFINITY: {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
        }
        return null;
    }

    protected Object parseNumber(String value) {
        try {
            Number number = NumberFormat.getInstance().parse(value);
            if (number instanceof Long) {
                return number.longValue();
            }
            return number.doubleValue();
        }
        catch (ParseException e) {
            throw new WebDriverException("The result from the script can not be parsed");
        }
    }

    protected final EcmascriptProtos.EvalArg.Variable buildVariable(String name, int objectId) {
        EcmascriptProtos.EvalArg.Variable.Builder variable = EcmascriptProtos.EvalArg.Variable.newBuilder();
        variable.setName(name);
        variable.setObjectID(objectId);
        return variable.build();
    }

    private EcmascriptProtos.EvalResult parseEvalData(UmsProtos.Response response) {
        EcmascriptProtos.EvalResult.Builder builder = EcmascriptProtos.EvalResult.newBuilder();
        EcmascriptService.buildPayload(response, builder);
        return builder.build();
    }

    @Override
    public void cleanUpRuntimes(int windowId) {
        for (EcmascriptProtos.Runtime runtime : this.runtimesList.values()) {
            if (runtime.getWindowID() != windowId) continue;
            this.runtimesList.remove(runtime.getRuntimeID());
        }
    }

    @Override
    public void cleanUpRuntimes() {
        int windowId = this.windowManager.getActiveWindowId();
        this.cleanUpRuntimes(windowId);
    }

    @Override
    public List<Integer> examineObjects(Integer objectId) {
        EcmascriptProtos.ExamineObjectsArg.Builder builder = EcmascriptProtos.ExamineObjectsArg.newBuilder();
        builder.setExaminePrototypes(false);
        builder.setRuntimeID(this.getRuntimeId());
        builder.addObjectIDList(objectId);
        UmsProtos.Response response = this.executeCommand(ESCommand.EXAMINE_OBJECTS, (AbstractMessage.Builder<?>)builder);
        EcmascriptProtos.ObjectList.Builder objListBuilder = EcmascriptProtos.ObjectList.newBuilder();
        EcmascriptService.buildPayload(response, objListBuilder);
        EcmascriptProtos.ObjectList list = objListBuilder.build();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<EcmascriptProtos.Object.Property> objects = list.getPrototypeListList().get(0).getObjectListList().get(0).getPropertyListList();
        for (EcmascriptProtos.Object.Property obj : objects) {
            if (!obj.getValue().getType().equals((Object)EcmascriptProtos.Value.Type.OBJECT)) continue;
            ids.add(obj.getValue().getObject().getObjectID());
        }
        return ids;
    }

    @Override
    public String executeJavascript(String using) {
        return this.executeJavascript(using, true);
    }

    @Override
    public String executeJavascript(String using, boolean responseExpected) {
        Object result = this.executeScript(using, responseExpected);
        return result == null ? null : String.valueOf(result);
    }

    @Override
    public Object executeScript(String using, boolean responseExpected) {
        UmsProtos.Response reply = this.eval(using, new EcmascriptProtos.EvalArg.Variable[0]);
        return responseExpected ? this.parseEvalReply(this.parseEvalData(reply)) : null;
    }

    @Override
    public Integer executeScriptOnObject(String using, int objectId) {
        EcmascriptProtos.EvalArg.Variable variable = this.buildVariable("locator", objectId);
        EcmascriptProtos.EvalResult reply = this.parseEvalData(this.eval(using, variable));
        Object object = this.parseEvalReply(reply);
        if (object == null || !(object instanceof EcmascriptProtos.Object)) {
            return null;
        }
        return ((EcmascriptProtos.Object)object).getObjectID();
    }

    @Override
    public Integer getObject(String using) {
        EcmascriptProtos.EvalResult reply = this.parseEvalData(this.eval(using, new EcmascriptProtos.EvalArg.Variable[0]));
        return reply.getValue().getType().equals((Object)EcmascriptProtos.Value.Type.OBJECT) ? Integer.valueOf(reply.getValue().getObject().getObjectID()) : null;
    }

    @Override
    public int getRuntimeId() {
        return this.runtime.getStamp();
    }

    @Override
    public void init() {
        if (!this.updateRuntime()) {
            throw new WebDriverException("Could not find a runtime for script injection");
        }
    }

    @Override
    public List<String> listFramePaths() {
        LinkedList<String> framePaths = new LinkedList<String>();
        Iterator itr = this.runtimesList.entrySet().iterator();
        while (itr.hasNext()) {
            framePaths.add(((EcmascriptProtos.Runtime)itr.next().getValue()).getHtmlFramePath());
        }
        return framePaths;
    }

    @Override
    public void releaseObjects() {
        this.releaseObject(0);
    }

    @Override
    public void removeRuntime(int runtimeId) {
        this.runtimesList.remove(runtimeId);
    }

    @Override
    public void resetRuntimesList() {
        this.runtimesList.clear();
    }

    @Override
    public Object scriptExecutor(String script, Object ... params) {
        if (this.windowManager.getActiveWindowId() != this.activeWindowId) {
            this.recover();
        }
        this.processQueues();
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        String toSend = this.buildEvalString(elements, script, params);
        EcmascriptProtos.EvalArg.Builder evalBuilder = this.buildEval(toSend);
        for (WebElement webElement : elements) {
            EcmascriptProtos.EvalArg.Variable variable = this.buildVariable(webElement.toString(), ((OperaWebElement)webElement).getObjectId());
            evalBuilder.addVariableList(variable);
        }
        UmsProtos.Response response = this.executeCommand(ESCommand.EVAL, (AbstractMessage.Builder<?>)evalBuilder);
        if (response == null) {
            throw new WebDriverException("Internal error while executing script");
        }
        EcmascriptProtos.EvalResult result = this.parseEvalData(response);
        Object parsed = this.parseEvalReply(result);
        if (parsed instanceof EcmascriptProtos.Object) {
            EcmascriptProtos.Object data = (EcmascriptProtos.Object)parsed;
            return new ScriptResult(data.getObjectID(), data.getClassName());
        }
        return parsed;
    }

    private EcmascriptProtos.EvalArg.Builder buildEval(String toSend) {
        EcmascriptProtos.EvalArg.Builder builder = EcmascriptProtos.EvalArg.newBuilder();
        builder.setRuntimeID(this.getRuntimeId());
        builder.setScriptData(toSend);
        return builder;
    }

    private String buildEvalString(List<WebElement> elements, String script, Object ... params) {
        String toSend;
        if (params != null && params.length > 0) {
            StringBuilder builder = new StringBuilder();
            for (Object object : params) {
                if (builder.toString().length() > 0) {
                    builder.append(",");
                }
                if (object instanceof Collection) {
                    builder.append("[");
                    Collection collection = (Collection)object;
                    for (Object argument : collection) {
                        this.processArgument(argument, builder, elements);
                    }
                    builder.append("]");
                    continue;
                }
                this.processArgument(object, builder, elements);
            }
            String arguments = builder.toString();
            toSend = "(function(){" + script + "})(" + arguments + ")";
        } else {
            toSend = script;
        }
        return toSend;
    }

    protected void processArgument(Object object, StringBuilder builder, List<WebElement> elements) {
        if (object instanceof WebElement) {
            elements.add((WebElement)object);
            builder.append(String.valueOf(object));
        } else if (object instanceof String) {
            builder.append("'" + String.valueOf(object) + "'");
        } else if (object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double) {
            builder.append(String.valueOf(object));
        } else {
            throw new IllegalArgumentException("The argument type is not supported");
        }
    }

    @Override
    public void setRuntime(EsdbgProtos.RuntimeInfo runtime) {
        throw new UnsupportedOperationException("Not suppported without ecmascript-debugger");
    }

    @Override
    public boolean updateRuntime() {
        this.createAllRuntimes();
        EcmascriptProtos.Runtime activeRuntime = this.findRuntime();
        if (activeRuntime != null) {
            this.setRuntime(activeRuntime);
            return true;
        }
        return false;
    }

    public void setRuntime(EcmascriptProtos.Runtime runtime) {
        this.runtime.set(runtime, runtime.getRuntimeID());
        this.activeWindowId = runtime.getWindowID();
    }

    protected EcmascriptProtos.Runtime findRuntime() {
        int windowId = this.windowManager.getActiveWindowId();
        EcmascriptProtos.Runtime runtime = (EcmascriptProtos.Runtime)this.xpathPointer(this.runtimesList.values(), "/.[htmlFramePath='_top' and windowID='" + windowId + "']").getValue();
        return runtime;
    }

    protected void createAllRuntimes() {
        EcmascriptProtos.ListRuntimesArg.Builder builder = EcmascriptProtos.ListRuntimesArg.newBuilder();
        builder.setCreate(true);
        UmsProtos.Response response = this.executeCommand(ESCommand.LIST_RUNTIMES, (AbstractMessage.Builder<?>)builder);
        this.runtimesList.clear();
        EcmascriptProtos.RuntimeList.Builder runtimeListBuilder = EcmascriptProtos.RuntimeList.newBuilder();
        EcmascriptService.buildPayload(response, runtimeListBuilder);
        List<EcmascriptProtos.Runtime> runtimes = runtimeListBuilder.build().getRuntimeListList();
        for (EcmascriptProtos.Runtime runtime : runtimes) {
            this.runtimesList.put(runtime.getRuntimeID(), runtime);
        }
    }

    @Override
    public void readyStateChanged(EcmascriptProtos.ReadyStateChange change) {
        if (!this.runtimesList.containsKey(change.getRuntimeID())) {
            this.runtimesQueue.add(change.getRuntimeID());
        }
    }

    private void processQueues() {
        if (!this.garbageQueue.isEmpty()) {
            this.processGcObjects();
        }
        if (!this.runtimesQueue.isEmpty()) {
            this.processNewRuntimes();
        }
        if (this.runtimesList.isEmpty()) {
            this.updateRuntime();
        }
    }

    private void processNewRuntimes() {
        while (!this.runtimesQueue.isEmpty()) {
            EcmascriptProtos.Runtime runtime = this.getRuntime(this.runtimesQueue.poll());
            if (runtime == null) continue;
            if (runtime.getHtmlFramePath().equals("_top") && this.windowManager.getActiveWindowId() == runtime.getWindowID()) {
                this.setRuntime(runtime);
            }
            this.runtimesList.putIfAbsent(runtime.getRuntimeID(), runtime);
        }
    }

    private void processGcObjects() {
        EcmascriptProtos.ReleaseObjectsArg.Builder builder = EcmascriptProtos.ReleaseObjectsArg.newBuilder();
        builder.addAllObjectIDList(this.garbageQueue);
        this.executeCommand(ESCommand.RELEASE_OBJECTS, (AbstractMessage.Builder<?>)builder);
        this.garbageQueue.clear();
    }

    private EcmascriptProtos.Runtime getRuntime(int runtimeID) {
        EcmascriptProtos.ListRuntimesArg.Builder builder = EcmascriptProtos.ListRuntimesArg.newBuilder();
        builder.addRuntimeIDList(runtimeID);
        builder.setCreate(true);
        UmsProtos.Response response = this.executeCommand(ESCommand.LIST_RUNTIMES, (AbstractMessage.Builder<?>)builder);
        EcmascriptProtos.RuntimeList.Builder runtimeListBuilder = EcmascriptProtos.RuntimeList.newBuilder();
        EcmascriptService.buildPayload(response, runtimeListBuilder);
        List<EcmascriptProtos.Runtime> runtimes = runtimeListBuilder.build().getRuntimeListList();
        return runtimes.isEmpty() ? null : runtimes.get(0);
    }

    @Override
    public void releaseObject(int objectId) {
        EcmascriptProtos.ReleaseObjectsArg.Builder builder = EcmascriptProtos.ReleaseObjectsArg.newBuilder();
        if (objectId != 0) {
            this.garbageQueue.add(objectId);
        } else {
            this.executeCommand(ESCommand.RELEASE_OBJECTS, (AbstractMessage.Builder<?>)builder);
        }
    }

    @Override
    public void resetFramePath() {
    }

    @Override
    public void changeRuntime(int index) {
    }

    @Override
    public void changeRuntime(String frameName) {
    }

    @Override
    public String executeJavascript(String using, Integer windowId) {
        return null;
    }

    @Override
    public Object examineScriptResult(Integer id) {
        return null;
    }
}

