/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.OperaDriver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.CommandLine;

public class OperaPaths {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public String operaPath() {
        String path = System.getenv("OPERA_PATH");
        if (this.isPathValid(path)) {
            return path;
        }
        if (!this.isPathValid(path) && path != null && path.length() > 0) {
            throw new WebDriverException("Path \"" + path + "\" in OPERA_PATH does not exist");
        }
        Platform platform = Platform.getCurrent();
        switch (platform) {
            case LINUX: 
            case UNIX: {
                path = "/usr/bin/opera";
                if (this.isPathValid(path)) break;
                CommandLine line = new CommandLine("which", new String[]{"opera"});
                line.execute();
                path = line.getStdOut().trim();
                break;
            }
            case MAC: {
                path = "/Applications/Opera.app/Contents/MacOS/Opera";
                break;
            }
            case WINDOWS: 
            case XP: 
            case VISTA: {
                String progfiles;
                String x86 = System.getenv("ProgramFiles(x86)");
                String string = progfiles = x86 == null ? System.getenv("PROGRAMFILES") : x86;
                if (progfiles == null) {
                    progfiles = "\\Program Files";
                }
                path = progfiles + "\\Opera\\opera.exe";
                break;
            }
            default: {
                throw new WebDriverException("Auto find is not support on this platform");
            }
        }
        return this.isPathValid(path) ? path : null;
    }

    public String launcherPath() {
        String path = System.getenv("OPERA_LAUNCHER");
        if (!this.isPathValid(path)) {
            if (path != null && path.length() > 0) {
                throw new WebDriverException("Path \"" + path + "\" in OPERA_LAUNCHER does not exist");
            }
            path = this.extractLauncher(FileUtils.getUserDirectoryPath() + File.separator + ".launcher");
        }
        return path;
    }

    private String extractLauncher(String launcherPath) {
        boolean copy;
        String launcherName = this.getLauncherNameForOS();
        File sourceLauncher = null;
        File targetLauncher = new File(launcherPath + File.separator + launcherName);
        URL res = OperaDriver.class.getClassLoader().getResource("launcher/" + launcherName);
        if (res != null) {
            this.logger.finer("launcher found among resources");
            String url = res.toExternalForm();
            if (url.startsWith("jar:") || url.startsWith("wsjar:")) {
                sourceLauncher = new File(url);
            }
        } else {
            this.logger.finer("Looking for launcher in source directory");
            File outputPath = new File(OperaDriver.class.getProtectionDomain().getCodeSource().getLocation().getPath());
            try {
                sourceLauncher = this.findLauncherInRepository(outputPath);
            }
            catch (FileNotFoundException e) {
                throw new WebDriverException("Unable to find launcher above the \"" + outputPath + "\" " + "output path, please extract the launcher manually or run " + "OperaDriver from the JAR the first time");
            }
        }
        if (!targetLauncher.exists()) {
            copy = true;
            this.logger.fine("No launcher found, copying");
        } else {
            try {
                copy = res != null ? !Arrays.equals(OperaPaths.md5(targetLauncher), OperaPaths.md5(res.openStream())) : !Arrays.equals(OperaPaths.md5(targetLauncher), OperaPaths.md5(sourceLauncher));
            }
            catch (Exception e) {
                copy = true;
                this.logger.fine("Old launcher detected, upgrading");
            }
        }
        if (copy) {
            try {
                if (!targetLauncher.exists()) {
                    new File(launcherPath).mkdirs();
                    FileUtils.touch((File)targetLauncher);
                }
                InputStream is = res != null ? res.openStream() : new FileInputStream(sourceLauncher);
                FileOutputStream os = new FileOutputStream(targetLauncher);
                IOUtils.copy((InputStream)is, (OutputStream)os);
                is.close();
                ((OutputStream)os).close();
                targetLauncher.setLastModified(targetLauncher.lastModified());
            }
            catch (IOException e) {
                throw new WebDriverException("Cannot write file to disk: " + e.getMessage());
            }
            this.logger.fine("New launcher copied to " + targetLauncher.getAbsolutePath());
        }
        if (copy && targetLauncher != null) {
            this.makeLauncherExecutable(targetLauncher);
        }
        return targetLauncher.getAbsolutePath();
    }

    private void makeLauncherExecutable(File launcher) {
        Platform current = Platform.getCurrent();
        if (current.is(Platform.LINUX) || current.is(Platform.MAC)) {
            CommandLine line = new CommandLine("chmod", new String[]{"755", launcher.getAbsolutePath()});
            line.execute();
        }
    }

    private String getLauncherNameForOS() {
        boolean is64 = "64".equals(System.getProperty("sun.arch.data.model"));
        Platform currentPlatform = Platform.getCurrent();
        switch (currentPlatform) {
            case LINUX: 
            case UNIX: {
                return is64 ? "launcher-linux-x86_64" : "launcher-linux-i686";
            }
            case MAC: {
                return "launcher-mac";
            }
            case WINDOWS: 
            case XP: 
            case VISTA: {
                return "launcher-win32-i86pc.exe";
            }
        }
        throw new WebDriverException("Could not find a platform that supports bundled launchers, please set it manually");
    }

    private boolean isPathValid(String path) {
        if (path == null) {
            return false;
        }
        if (path.length() == 0) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    private static byte[] md5(InputStream fis) throws Exception {
        int numRead;
        byte[] buffer = new byte[1024];
        MessageDigest complete = MessageDigest.getInstance("MD5");
        do {
            if ((numRead = fis.read(buffer)) <= 0) continue;
            complete.update(buffer, 0, numRead);
        } while (numRead != -1);
        fis.close();
        return complete.digest();
    }

    private static byte[] md5(File file) throws Exception {
        return OperaPaths.md5(new FileInputStream(file));
    }

    private File findLauncherInRepository(File outputPath) throws FileNotFoundException {
        File launcher = new File(this.findLauncherDirectoryInRepository(outputPath) + File.separator + this.getLauncherNameForOS());
        if (launcher.exists()) {
            return launcher;
        }
        throw new FileNotFoundException();
    }

    private File findLauncherDirectoryInRepository(File outputPath) {
        FilenameFilter launcherDirectoryFilter = new FilenameFilter(){

            public boolean accept(File file, String name) {
                return name.equals("launcher");
            }
        };
        File parent = new File(outputPath.getParent());
        File current = null;
        for (int i = 3; i >= 0; --i) {
            current = new File(parent.getParent());
            String[] currentChildren = current.list(launcherDirectoryFilter);
            if (currentChildren.length == 1) {
                current = new File(current.getAbsolutePath() + File.separator + "launcher");
                break;
            }
            parent = current;
        }
        if (current != null) {
            return current;
        }
        return null;
    }
}

