/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.opentable.db.postgres.embedded.ConnectionInfo;
import com.opentable.db.postgres.embedded.DatabasePreparer;
import com.opentable.db.postgres.embedded.EmbeddedPostgres;
import com.opentable.db.postgres.embedded.JdbcUrlUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.commons.lang3.RandomStringUtils;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedDbProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PreparedDbProvider.class);
    private static final Map<ClusterKey, PrepPipeline> CLUSTERS = new HashMap<ClusterKey, PrepPipeline>();
    private final PrepPipeline dbPreparer;

    public static PreparedDbProvider forPreparer(DatabasePreparer preparer) {
        return PreparedDbProvider.forPreparer(preparer, Collections.emptyList());
    }

    public static PreparedDbProvider forPreparer(DatabasePreparer preparer, Iterable<Consumer<EmbeddedPostgres.Builder>> customizers) {
        return new PreparedDbProvider(preparer, customizers);
    }

    private PreparedDbProvider(DatabasePreparer preparer, Iterable<Consumer<EmbeddedPostgres.Builder>> customizers) {
        try {
            this.dbPreparer = PreparedDbProvider.createOrFindPreparer(preparer, customizers);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static synchronized PrepPipeline createOrFindPreparer(DatabasePreparer preparer, Iterable<Consumer<EmbeddedPostgres.Builder>> customizers) throws IOException, SQLException {
        ClusterKey key = new ClusterKey(preparer, customizers);
        PrepPipeline result = CLUSTERS.get(key);
        if (result != null) {
            return result;
        }
        EmbeddedPostgres.Builder builder = EmbeddedPostgres.builder();
        customizers.forEach(c -> c.accept(builder));
        EmbeddedPostgres pg = builder.start();
        preparer.prepare(pg.getTemplateDatabase());
        result = new PrepPipeline(pg).start();
        CLUSTERS.put(key, result);
        return result;
    }

    public String createDatabase() throws SQLException {
        DbInfo info = this.createNewDB();
        if (!info.isSuccess()) {
            return null;
        }
        try {
            return JdbcUrlUtils.addUsernamePassword(info.getUrl(), info.getUser(), info.getPassword());
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new SQLException(e);
        }
    }

    private DbInfo createNewDB() throws SQLException {
        return this.dbPreparer.getNextDb();
    }

    public ConnectionInfo createNewDatabase() throws SQLException {
        DbInfo dbInfo = this.createNewDB();
        return !dbInfo.isSuccess() ? null : new ConnectionInfo(dbInfo.getUrl(), dbInfo.getUser(), dbInfo.getPassword(), dbInfo.getHost(), dbInfo.getPort());
    }

    public DataSource createDataSourceFromConnectionInfo(ConnectionInfo connectionInfo) {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        ds.setUrl(connectionInfo.getUrl());
        ds.setUser(connectionInfo.getUser());
        ds.setPassword(connectionInfo.getPassword());
        return ds;
    }

    public DataSource createDataSource() throws SQLException {
        return this.createDataSourceFromConnectionInfo(this.createNewDatabase());
    }

    public Map<String, String> getConfigurationTweak(String dbModuleName) throws SQLException {
        DbInfo db = this.dbPreparer.getNextDb();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("ot.db." + dbModuleName + ".uri", db.getUrl());
        result.put("ot.db." + dbModuleName + ".ds.user", db.user);
        result.put("ot.db." + dbModuleName + ".ds.password", db.password);
        return result;
    }

    private static void create(DataSource connectDb, String dbName, String userName) throws SQLException {
        if (dbName == null) {
            throw new IllegalStateException("the database name must not be null!");
        }
        if (userName == null) {
            throw new IllegalStateException("the user name must not be null!");
        }
        try (Connection c = connectDb.getConnection();
             PreparedStatement stmt = c.prepareStatement(String.format("CREATE DATABASE %s OWNER %s ENCODING = 'utf8'", dbName, userName));){
            LOG.debug("Statement: {}", (Object)stmt);
            stmt.execute();
        }
    }

    private static class PrepPipeline
    implements Runnable {
        private final EmbeddedPostgres pg;
        private final SynchronousQueue<DbInfo> nextDatabase = new SynchronousQueue();

        PrepPipeline(EmbeddedPostgres pg) {
            this.pg = pg;
        }

        PrepPipeline start() {
            ExecutorService service = Executors.newSingleThreadExecutor(r -> {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("cluster-" + this.pg + "-preparer");
                return t;
            });
            service.submit(this);
            service.shutdown();
            return this;
        }

        DbInfo getNextDb() throws SQLException {
            try {
                DbInfo next = this.nextDatabase.take();
                if (next.ex != null) {
                    throw new SQLException(next.ex);
                }
                return next;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void run() {
            while (true) {
                String newDbName = "pge_" + RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ENGLISH);
                SQLException failure = null;
                try {
                    PreparedDbProvider.create(this.pg.getPostgresDatabase(), newDbName, this.pg.getUserName());
                }
                catch (SQLException e) {
                    failure = e;
                }
                try {
                    if (failure == null) {
                        this.nextDatabase.put(DbInfo.ok(this.pg.getJdbcUrl(newDbName), this.pg.getUserName(), this.pg.getPassword(), this.pg.getHost(), this.pg.getPort()));
                        continue;
                    }
                    this.nextDatabase.put(DbInfo.error(failure));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    private static class ClusterKey {
        private final DatabasePreparer preparer;
        private final EmbeddedPostgres.Builder builder;

        ClusterKey(DatabasePreparer preparer, Iterable<Consumer<EmbeddedPostgres.Builder>> customizers) {
            this.preparer = preparer;
            this.builder = EmbeddedPostgres.builder();
            customizers.forEach(c -> c.accept(this.builder));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterKey that = (ClusterKey)o;
            return Objects.equals(this.preparer, that.preparer) && Objects.equals(this.builder, that.builder);
        }

        public int hashCode() {
            return Objects.hash(this.preparer, this.builder);
        }
    }

    public static class DbInfo {
        private final String url;
        private final String user;
        private final String password;
        private final SQLException ex;
        private final String host;
        private final int port;

        public static DbInfo ok(String url, String user, String password, String host, int port) {
            return new DbInfo(url, user, password, null, host, port);
        }

        public static DbInfo error(SQLException e) {
            return new DbInfo(null, null, null, e, null, -1);
        }

        private DbInfo(String url, String user, String password, SQLException e, String host, int port) {
            this.url = url;
            this.user = user;
            this.password = password;
            this.ex = e;
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUser() {
            return this.user;
        }

        public SQLException getException() {
            return this.ex;
        }

        public boolean isSuccess() {
            return this.ex == null;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

