/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.opentable.db.postgres.embedded.EmbeddedUtil;
import com.opentable.db.postgres.embedded.PgBinaryResolver;
import com.opentable.db.postgres.embedded.PgDirectoryResolver;
import com.opentable.db.postgres.embedded.ProcessOutputLogger;
import com.opentable.db.postgres.embedded.UncompressBundleDirectoryResolver;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
public class EmbeddedPostgres
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedPostgres.class);
    private static final String LOG_PREFIX = EmbeddedPostgres.class.getName() + ".";
    private static final String JDBC_FORMAT = "jdbc:postgresql://localhost:%s/%s?user=%s";
    private static final String PG_STOP_MODE = "fast";
    private static final String PG_STOP_WAIT_S = "5";
    private static final String PG_SUPERUSER = "postgres";
    private static final Duration DEFAULT_PG_STARTUP_WAIT = Duration.ofSeconds(10L);
    private static final String LOCK_FILE_NAME = "epg-lock";
    private final File pgDir;
    private final Duration pgStartupWait;
    private final File dataDirectory;
    private final File lockFile;
    private final UUID instanceId = UUID.randomUUID();
    private final int port;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Map<String, String> postgresConfig;
    private final Map<String, String> localeConfig;
    private volatile FileOutputStream lockStream;
    private volatile FileLock lock;
    private final boolean cleanDataDirectory;
    private final ProcessBuilder.Redirect errorRedirector;
    private final ProcessBuilder.Redirect outputRedirector;

    EmbeddedPostgres(File parentDirectory, File dataDirectory, boolean cleanDataDirectory, Map<String, String> postgresConfig, Map<String, String> localeConfig, int port, Map<String, String> connectConfig, PgDirectoryResolver pgDirectoryResolver, ProcessBuilder.Redirect errorRedirector, ProcessBuilder.Redirect outputRedirector) throws IOException {
        this(parentDirectory, dataDirectory, cleanDataDirectory, postgresConfig, localeConfig, port, connectConfig, pgDirectoryResolver, errorRedirector, outputRedirector, DEFAULT_PG_STARTUP_WAIT, Optional.empty());
    }

    EmbeddedPostgres(File parentDirectory, File dataDirectory, boolean cleanDataDirectory, Map<String, String> postgresConfig, Map<String, String> localeConfig, int port, Map<String, String> connectConfig, PgDirectoryResolver pgDirectoryResolver, ProcessBuilder.Redirect errorRedirector, ProcessBuilder.Redirect outputRedirector, Duration pgStartupWait, Optional<File> overrideWorkingDirectory) throws IOException {
        this.cleanDataDirectory = cleanDataDirectory;
        this.postgresConfig = new HashMap<String, String>(postgresConfig);
        this.localeConfig = new HashMap<String, String>(localeConfig);
        this.port = port;
        this.pgDir = pgDirectoryResolver.getDirectory(overrideWorkingDirectory);
        this.errorRedirector = errorRedirector;
        this.outputRedirector = outputRedirector;
        this.pgStartupWait = Objects.requireNonNull(pgStartupWait, "Wait time cannot be null");
        if (parentDirectory != null) {
            EmbeddedUtil.mkdirs(parentDirectory);
            this.cleanOldDataDirectories(parentDirectory);
            this.dataDirectory = dataDirectory != null ? dataDirectory : new File(parentDirectory, this.instanceId.toString());
        } else {
            this.dataDirectory = dataDirectory;
        }
        if (this.dataDirectory == null) {
            throw new IllegalArgumentException("no data directory");
        }
        LOG.debug("{} postgres: data directory is {}, postgres directory is {}", new Object[]{this.instanceId, this.dataDirectory, this.pgDir});
        EmbeddedUtil.mkdirs(this.dataDirectory);
        this.lockFile = new File(this.dataDirectory, LOCK_FILE_NAME);
        if (cleanDataDirectory || !new File(dataDirectory, "postgresql.conf").exists()) {
            this.initdb();
        }
        this.lock();
        this.startPostmaster(connectConfig);
    }

    public DataSource getTemplateDatabase() {
        return this.getDatabase(PG_SUPERUSER, "template1");
    }

    public DataSource getTemplateDatabase(Map<String, String> properties) {
        return this.getDatabase(PG_SUPERUSER, "template1", properties);
    }

    public DataSource getPostgresDatabase() {
        return this.getDatabase(PG_SUPERUSER, PG_SUPERUSER);
    }

    public DataSource getPostgresDatabase(Map<String, String> properties) {
        return this.getDatabase(PG_SUPERUSER, PG_SUPERUSER, properties);
    }

    public DataSource getDatabase(String userName, String dbName) {
        return this.getDatabase(userName, dbName, Collections.emptyMap());
    }

    public DataSource getDatabase(String userName, String dbName, Map<String, String> properties) {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        ds.setServerName("localhost");
        ds.setPortNumber(this.port);
        ds.setDatabaseName(dbName);
        ds.setUser(userName);
        properties.forEach((propertyKey, propertyValue) -> {
            try {
                ds.setProperty(propertyKey, propertyValue);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        return ds;
    }

    public String getJdbcUrl(String userName, String dbName) {
        return String.format(JDBC_FORMAT, this.port, dbName, userName);
    }

    public int getPort() {
        return this.port;
    }

    private static int detectPort() throws IOException {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            while (!socket.isBound()) {
                Thread.sleep(50L);
            }
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread interrupted", e);
            }
        }
        socket.close();
        return n;
    }

    private void lock() throws IOException {
        this.lockStream = new FileOutputStream(this.lockFile);
        this.lock = this.lockStream.getChannel().tryLock();
        if (this.lock == null) {
            throw new IllegalStateException("could not lock " + this.lockFile);
        }
    }

    private void initdb() {
        StopWatch watch = new StopWatch();
        watch.start();
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(Arrays.asList(this.pgBin("initdb"), "-A", "trust", "-U", PG_SUPERUSER, "-D", this.dataDirectory.getPath(), "-E", "UTF-8"));
        command.addAll(this.createLocaleOptions());
        this.system(command.toArray(new String[command.size()]));
        LOG.info("{} initdb completed in {}", (Object)this.instanceId, (Object)watch);
    }

    private void startPostmaster(Map<String, String> connectConfig) throws IOException {
        StopWatch watch = new StopWatch();
        watch.start();
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("Postmaster already started");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(this.pgBin("pg_ctl"), "-D", this.dataDirectory.getPath(), "-o", this.createInitOptions().stream().collect(Collectors.joining(" ")), "start"));
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.redirectErrorStream(true);
        builder.redirectError(this.errorRedirector);
        builder.redirectOutput(this.outputRedirector);
        Process postmaster = builder.start();
        if (this.outputRedirector.type() == ProcessBuilder.Redirect.Type.PIPE) {
            ProcessOutputLogger.logOutput(LoggerFactory.getLogger((String)("pg-" + this.instanceId)), postmaster);
        } else if (this.outputRedirector.type() == ProcessBuilder.Redirect.Type.APPEND) {
            ProcessOutputLogger.logOutput(LoggerFactory.getLogger((String)(LOG_PREFIX + "pg-" + this.instanceId)), postmaster);
        }
        LOG.info("{} postmaster started as {} on port {}.  Waiting up to {} for server startup to finish.", new Object[]{this.instanceId, postmaster.toString(), this.port, this.pgStartupWait});
        Runtime.getRuntime().addShutdownHook(this.newCloserThread());
        this.waitForServerStartup(watch, connectConfig);
    }

    private List<String> createInitOptions() {
        ArrayList<String> initOptions = new ArrayList<String>();
        initOptions.addAll(Arrays.asList("-p", Integer.toString(this.port), "-F"));
        for (Map.Entry<String, String> config : this.postgresConfig.entrySet()) {
            initOptions.add("-c");
            initOptions.add(config.getKey() + "=" + config.getValue());
        }
        return initOptions;
    }

    private List<String> createLocaleOptions() {
        ArrayList<String> localeOptions = new ArrayList<String>();
        for (Map.Entry<String, String> config : this.localeConfig.entrySet()) {
            if (SystemUtils.IS_OS_WINDOWS) {
                localeOptions.add(String.format("--%s=%s", config.getKey(), config.getValue()));
                continue;
            }
            localeOptions.add("--" + config.getKey());
            localeOptions.add(config.getValue());
        }
        return localeOptions;
    }

    private void waitForServerStartup(StopWatch watch, Map<String, String> connectConfig) throws IOException {
        SQLException lastCause = null;
        long start = System.nanoTime();
        long maxWaitNs = TimeUnit.NANOSECONDS.convert(this.pgStartupWait.toMillis(), TimeUnit.MILLISECONDS);
        while (System.nanoTime() - start < maxWaitNs) {
            try {
                this.verifyReady(connectConfig);
                LOG.info("{} postmaster startup finished in {}", (Object)this.instanceId, (Object)watch);
                return;
            }
            catch (SQLException e) {
                lastCause = e;
                LOG.trace("While waiting for server startup", (Throwable)e);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
        throw new IOException("Gave up waiting for server to start after " + this.pgStartupWait.toMillis() + "ms", lastCause);
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private void verifyReady(Map<String, String> connectConfig) throws SQLException {
        InetAddress localhost = InetAddress.getLoopbackAddress();
        try (Socket sock = new Socket();){
            sock.setSoTimeout((int)Duration.ofMillis(500L).toMillis());
            sock.connect(new InetSocketAddress(localhost, this.port), (int)Duration.ofMillis(500L).toMillis());
        }
        catch (IOException e) {
            throw new SQLException("connect failed", e);
        }
        try (Connection c = this.getPostgresDatabase(connectConfig).getConnection();
             Statement s = c.createStatement();
             ResultSet rs = s.executeQuery("SELECT 1");){
            if (!rs.next()) {
                throw new IllegalStateException("expecting single row");
            }
            if (1 != rs.getInt(1)) {
                throw new IllegalStateException("expecting 1");
            }
            if (rs.next()) {
                throw new IllegalStateException("expecting single row");
            }
        }
    }

    private Thread newCloserThread() {
        Thread closeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    EmbeddedPostgres.this.close();
                }
                catch (IOException ex) {
                    LOG.error("Unexpected IOException from Closeables.close", (Throwable)ex);
                }
            }
        });
        closeThread.setName("postgres-" + this.instanceId + "-closer");
        return closeThread;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            this.pgCtl(this.dataDirectory, "stop");
            LOG.info("{} shut down postmaster in {}", (Object)this.instanceId, (Object)watch);
        }
        catch (Exception e) {
            LOG.error("Could not stop postmaster " + this.instanceId, (Throwable)e);
        }
        if (this.lock != null) {
            this.lock.release();
        }
        try {
            this.lockStream.close();
        }
        catch (IOException e) {
            LOG.error("while closing lockStream", (Throwable)e);
        }
        if (this.cleanDataDirectory && System.getProperty("ot.epg.no-cleanup") == null) {
            try {
                FileUtils.deleteDirectory((File)this.dataDirectory);
            }
            catch (IOException e) {
                LOG.error("Could not clean up directory {}", (Object)this.dataDirectory.getAbsolutePath());
            }
        } else {
            LOG.info("Did not clean up directory {}", (Object)this.dataDirectory.getAbsolutePath());
        }
    }

    private void pgCtl(File dir, String action) {
        this.system(this.pgBin("pg_ctl"), "-D", dir.getPath(), action, "-m", PG_STOP_MODE, "-t", PG_STOP_WAIT_S, "-w");
    }

    private void cleanOldDataDirectories(File parentDirectory) {
        File[] children = parentDirectory.listFiles();
        if (children == null) {
            return;
        }
        for (File dir : children) {
            boolean isTooNew;
            if (!dir.isDirectory()) continue;
            File lockFile = new File(dir, LOCK_FILE_NAME);
            boolean bl = isTooNew = System.currentTimeMillis() - lockFile.lastModified() < 600000L;
            if (!lockFile.exists() || isTooNew) continue;
            try (FileOutputStream fos = new FileOutputStream(lockFile);
                 FileLock lock = fos.getChannel().tryLock();){
                if (lock == null) continue;
                LOG.info("Found stale data directory {}", (Object)dir);
                if (new File(dir, "postmaster.pid").exists()) {
                    try {
                        this.pgCtl(dir, "stop");
                        LOG.info("Shut down orphaned postmaster!");
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn("Failed to stop postmaster " + dir, (Throwable)e);
                        }
                        LOG.warn("Failed to stop postmaster " + dir + ": " + e.getMessage());
                    }
                }
                FileUtils.deleteDirectory((File)dir);
            }
            catch (OverlappingFileLockException e) {
                LOG.trace("While cleaning old data directories", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("While cleaning old data directories", (Throwable)e);
            }
        }
    }

    private String pgBin(String binaryName) {
        String extension = SystemUtils.IS_OS_WINDOWS ? ".exe" : "";
        return new File(this.pgDir, "bin/" + binaryName + extension).getPath();
    }

    public static EmbeddedPostgres start() throws IOException {
        return EmbeddedPostgres.builder().start();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void system(String ... command) {
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            builder.redirectError(this.errorRedirector);
            builder.redirectOutput(this.outputRedirector);
            Process process = builder.start();
            if (this.outputRedirector.type() == ProcessBuilder.Redirect.Type.PIPE) {
                ProcessOutputLogger.logOutput(LoggerFactory.getLogger((String)("init-" + this.instanceId + ":" + FilenameUtils.getName((String)command[0]))), process);
            } else if (this.outputRedirector.type() == ProcessBuilder.Redirect.Type.APPEND) {
                ProcessOutputLogger.logOutput(LoggerFactory.getLogger((String)(LOG_PREFIX + "init-" + this.instanceId + ":" + FilenameUtils.getName((String)command[0]))), process);
            }
            if (0 != process.waitFor()) {
                throw new IllegalStateException(String.format("Process %s failed%n%s", Arrays.asList(command), IOUtils.toString((InputStream)process.getErrorStream(), (Charset)StandardCharsets.UTF_8)));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "EmbeddedPG-" + this.instanceId;
    }

    static /* synthetic */ Duration access$100() {
        return DEFAULT_PG_STARTUP_WAIT;
    }

    public static class Builder {
        private final File parentDirectory = EmbeddedUtil.getWorkingDirectory();
        private Optional<File> overrideWorkingDirectory = Optional.empty();
        private File builderDataDirectory;
        private final Map<String, String> config = new HashMap<String, String>();
        private final Map<String, String> localeConfig = new HashMap<String, String>();
        private boolean builderCleanDataDirectory = true;
        private int builderPort = 0;
        private final Map<String, String> connectConfig = new HashMap<String, String>();
        private PgDirectoryResolver pgDirectoryResolver;
        private Duration pgStartupWait = EmbeddedPostgres.access$100();
        private ProcessBuilder.Redirect errRedirector = ProcessBuilder.Redirect.PIPE;
        private ProcessBuilder.Redirect outRedirector = ProcessBuilder.Redirect.PIPE;

        Builder() {
            this.config.put("timezone", "UTC");
            this.config.put("synchronous_commit", "off");
            this.config.put("max_connections", "300");
        }

        public Builder setPGStartupWait(Duration pgStartupWait) {
            Objects.requireNonNull(pgStartupWait);
            if (pgStartupWait.isNegative()) {
                throw new IllegalArgumentException("Negative durations are not permitted.");
            }
            this.pgStartupWait = pgStartupWait;
            return this;
        }

        public Builder setCleanDataDirectory(boolean cleanDataDirectory) {
            this.builderCleanDataDirectory = cleanDataDirectory;
            return this;
        }

        public Builder setDataDirectory(Path path) {
            return this.setDataDirectory(path.toFile());
        }

        public Builder setDataDirectory(File directory) {
            this.builderDataDirectory = directory;
            return this;
        }

        public Builder setDataDirectory(String path) {
            return this.setDataDirectory(new File(path));
        }

        public Builder setServerConfig(String key, String value) {
            this.config.put(key, value);
            return this;
        }

        public Builder setLocaleConfig(String key, String value) {
            this.localeConfig.put(key, value);
            return this;
        }

        public Builder setConnectConfig(String key, String value) {
            this.connectConfig.put(key, value);
            return this;
        }

        public Builder setOverrideWorkingDirectory(File workingDirectory) {
            this.overrideWorkingDirectory = Optional.ofNullable(workingDirectory);
            return this;
        }

        public Builder setPort(int port) {
            this.builderPort = port;
            return this;
        }

        public Builder setErrorRedirector(ProcessBuilder.Redirect errRedirector) {
            this.errRedirector = errRedirector;
            return this;
        }

        public Builder setOutputRedirector(ProcessBuilder.Redirect outRedirector) {
            this.outRedirector = outRedirector;
            return this;
        }

        @Deprecated
        public Builder setPgBinaryResolver(PgBinaryResolver pgBinaryResolver) {
            return this.setPgDirectoryResolver(new UncompressBundleDirectoryResolver(pgBinaryResolver));
        }

        public Builder setPgDirectoryResolver(PgDirectoryResolver pgDirectoryResolver) {
            this.pgDirectoryResolver = pgDirectoryResolver;
            return this;
        }

        public Builder setPostgresBinaryDirectory(File directory) {
            return this.setPgDirectoryResolver(x -> directory);
        }

        public EmbeddedPostgres start() throws IOException {
            if (this.builderPort == 0) {
                this.builderPort = EmbeddedPostgres.detectPort();
            }
            if (this.builderDataDirectory == null) {
                this.builderDataDirectory = Files.createTempDirectory("epg", new FileAttribute[0]).toFile();
            }
            if (this.pgDirectoryResolver == null) {
                LOG.trace("pgDirectoryResolver not overriden, using default (UncompressBundleDirectoryResolver)");
                this.pgDirectoryResolver = UncompressBundleDirectoryResolver.getDefault();
            }
            return new EmbeddedPostgres(this.parentDirectory, this.builderDataDirectory, this.builderCleanDataDirectory, this.config, this.localeConfig, this.builderPort, this.connectConfig, this.pgDirectoryResolver, this.errRedirector, this.outRedirector, this.pgStartupWait, this.overrideWorkingDirectory);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return this.builderCleanDataDirectory == builder.builderCleanDataDirectory && this.builderPort == builder.builderPort && Objects.equals(this.parentDirectory, builder.parentDirectory) && Objects.equals(this.builderDataDirectory, builder.builderDataDirectory) && Objects.equals(this.config, builder.config) && Objects.equals(this.localeConfig, builder.localeConfig) && Objects.equals(this.connectConfig, builder.connectConfig) && Objects.equals(this.pgDirectoryResolver, builder.pgDirectoryResolver) && Objects.equals(this.pgStartupWait, builder.pgStartupWait) && Objects.equals(this.errRedirector, builder.errRedirector) && Objects.equals(this.outRedirector, builder.outRedirector);
        }

        public int hashCode() {
            return Objects.hash(this.parentDirectory, this.builderDataDirectory, this.config, this.localeConfig, this.builderCleanDataDirectory, this.builderPort, this.connectConfig, this.pgDirectoryResolver, this.pgStartupWait, this.errRedirector, this.outRedirector);
        }
    }
}

