/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.util.PatternMatcher;
import com.opensymphony.xwork2.util.WildcardHelper;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathFinder {
    private String pattern;
    private int[] compiledPattern;
    private PatternMatcher patternMatcher = new WildcardHelper();
    private Vector<String> compared = new Vector();

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Vector<String> findMatches() {
        Vector<String> matches = new Vector<String>();
        URLClassLoader cl = this.getURLClassLoader();
        if (cl == null) {
            throw new XWorkException("unable to attain an URLClassLoader");
        }
        URL[] parentUrls = cl.getURLs();
        this.compiledPattern = (int[])this.patternMatcher.compilePattern(this.pattern);
        for (URL url : parentUrls) {
            URI entryURI;
            if (!url.getProtocol().equals("file")) continue;
            try {
                entryURI = url.toURI();
            }
            catch (URISyntaxException e) {
                continue;
            }
            File entry = new File(entryURI);
            Vector<String> results = this.checkEntries(entry.list(), entry, "");
            if (results == null) continue;
            matches.addAll(results);
        }
        return matches;
    }

    private Vector<String> checkEntries(String[] entries, File parent, String prefix) {
        if (entries == null) {
            return null;
        }
        Vector<String> matches = new Vector<String>();
        for (String listEntry : entries) {
            File tempFile = !prefix.equals("") ? new File(parent, prefix + "/" + listEntry) : new File(parent, listEntry);
            if (tempFile.isDirectory() && !listEntry.equals(".") && !listEntry.equals("..")) {
                if (!prefix.equals("")) {
                    matches.addAll(this.checkEntries(tempFile.list(), parent, prefix + "/" + listEntry));
                    continue;
                }
                matches.addAll(this.checkEntries(tempFile.list(), parent, listEntry));
                continue;
            }
            String entryToCheck = prefix.equals("") ? listEntry : prefix + "/" + listEntry;
            if (this.compared.contains(entryToCheck)) continue;
            this.compared.add(entryToCheck);
            boolean doesMatch = this.patternMatcher.match(new HashMap<String, String>(), entryToCheck, this.compiledPattern);
            if (!doesMatch) continue;
            matches.add(entryToCheck);
        }
        return matches;
    }

    public void setPatternMatcher(PatternMatcher patternMatcher) {
        this.patternMatcher = patternMatcher;
    }

    private URLClassLoader getURLClassLoader() {
        URLClassLoader ucl = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!(loader instanceof URLClassLoader)) {
            loader = ClassPathFinder.class.getClassLoader();
            if (loader instanceof URLClassLoader) {
                ucl = (URLClassLoader)loader;
            }
        } else {
            ucl = (URLClassLoader)loader;
        }
        return ucl;
    }
}

