/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.util.OgnlUtil;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import ognl.OgnlRuntime;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalizedTextUtil {
    private static final Log _log = LogFactory.getLog(LocalizedTextUtil.class);
    private static List DEFAULT_RESOURCE_BUNDLES = null;
    private static final Log LOG = LogFactory.getLog(LocalizedTextUtil.class);
    private static boolean reloadBundles = false;
    private static final Map<String, String> misses = new HashMap<String, String>();
    private static final Map messageFormats = new HashMap();

    public static void clearDefaultResourceBundles() {
        if (DEFAULT_RESOURCE_BUNDLES != null) {
            DEFAULT_RESOURCE_BUNDLES.clear();
        }
        DEFAULT_RESOURCE_BUNDLES = Collections.synchronizedList(new ArrayList());
        DEFAULT_RESOURCE_BUNDLES.add("com/opensymphony/xwork2/xwork-messages");
    }

    public static void setReloadBundles(boolean reloadBundles) {
        LocalizedTextUtil.reloadBundles = reloadBundles;
    }

    public static void addDefaultResourceBundle(String resourceBundleName) {
        DEFAULT_RESOURCE_BUNDLES.remove(resourceBundleName);
        DEFAULT_RESOURCE_BUNDLES.add(0, resourceBundleName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added default resource bundle '" + resourceBundleName + "' to default resource bundles = " + DEFAULT_RESOURCE_BUNDLES));
        }
    }

    public static Locale localeFromString(String localeStr, Locale defaultLocale) {
        if (localeStr == null || localeStr.trim().length() == 0 || localeStr.equals("_")) {
            if (defaultLocale != null) {
                return defaultLocale;
            }
            return Locale.getDefault();
        }
        int index = localeStr.indexOf(95);
        if (index < 0) {
            return new Locale(localeStr);
        }
        String language = localeStr.substring(0, index);
        if (index == localeStr.length()) {
            return new Locale(language);
        }
        if ((index = (localeStr = localeStr.substring(index + 1)).indexOf(95)) < 0) {
            return new Locale(language, localeStr);
        }
        String country = localeStr.substring(0, index);
        if (index == localeStr.length()) {
            return new Locale(language, country);
        }
        localeStr = localeStr.substring(index + 1);
        return new Locale(language, country, localeStr);
    }

    public static String findDefaultText(String aTextName, Locale locale) {
        List localList = DEFAULT_RESOURCE_BUNDLES;
        for (String bundleName : localList) {
            ResourceBundle bundle = LocalizedTextUtil.findResourceBundle(bundleName, locale);
            if (bundle == null) continue;
            LocalizedTextUtil.reloadBundles();
            try {
                return bundle.getString(aTextName);
            }
            catch (MissingResourceException e) {
            }
        }
        return null;
    }

    public static String findDefaultText(String aTextName, Locale locale, Object[] params) {
        String defaultText = LocalizedTextUtil.findDefaultText(aTextName, locale);
        if (defaultText != null) {
            MessageFormat mf = LocalizedTextUtil.buildMessageFormat(defaultText, locale);
            return mf.format(params);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle findResourceBundle(String aBundleName, Locale locale) {
        Map<String, String> map = misses;
        synchronized (map) {
            String key = LocalizedTextUtil.createMissesKey(aBundleName, locale);
            try {
                if (!misses.containsKey(key)) {
                    return ResourceBundle.getBundle(aBundleName, locale, Thread.currentThread().getContextClassLoader());
                }
            }
            catch (MissingResourceException ex) {
                misses.put(key, aBundleName);
            }
        }
        return null;
    }

    private static String createMissesKey(String aBundleName, Locale locale) {
        return aBundleName + "_" + locale.toString();
    }

    public static String findText(Class aClass, String aTextName, Locale locale) {
        return LocalizedTextUtil.findText(aClass, aTextName, locale, aTextName, new Object[0]);
    }

    public static String findText(Class aClass, String aTextName, Locale locale, String defaultMessage, Object[] args) {
        ValueStack valueStack = ActionContext.getContext().getValueStack();
        return LocalizedTextUtil.findText(aClass, aTextName, locale, defaultMessage, args, valueStack);
    }

    public static String findText(Class aClass, String aTextName, Locale locale, String defaultMessage, Object[] args, ValueStack valueStack) {
        Object model;
        Object action;
        ActionContext context;
        ActionInvocation actionInvocation;
        String msg;
        String indexedTextName = null;
        if (aTextName == null) {
            LOG.warn((Object)"Trying to find text with null key!");
            aTextName = "";
        }
        if (aTextName.indexOf("[") != -1) {
            int i = -1;
            indexedTextName = aTextName;
            while ((i = indexedTextName.indexOf("[", i + 1)) != -1) {
                int j = indexedTextName.indexOf("]", i);
                String a = indexedTextName.substring(0, i);
                String b = indexedTextName.substring(j);
                indexedTextName = a + "[*" + b;
            }
        }
        if ((msg = LocalizedTextUtil.findMessage(aClass, aTextName, indexedTextName, locale, args, null, valueStack)) != null) {
            return msg;
        }
        if (ModelDriven.class.isAssignableFrom(aClass) && (actionInvocation = (context = ActionContext.getContext()).getActionInvocation()) != null && (action = actionInvocation.getAction()) instanceof ModelDriven && (model = ((ModelDriven)action).getModel()) != null && (msg = LocalizedTextUtil.findMessage(model.getClass(), aTextName, indexedTextName, locale, args, null, valueStack)) != null) {
            return msg;
        }
        for (Class clazz = aClass; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            String basePackageName = clazz.getName();
            while (basePackageName.lastIndexOf(46) != -1) {
                String packageName = (basePackageName = basePackageName.substring(0, basePackageName.lastIndexOf(46))) + ".package";
                msg = LocalizedTextUtil.getMessage(packageName, locale, aTextName, valueStack, args);
                if (msg != null) {
                    return msg;
                }
                if (indexedTextName == null || (msg = LocalizedTextUtil.getMessage(packageName, locale, indexedTextName, valueStack, args)) == null) continue;
                return msg;
            }
        }
        int idx = aTextName.indexOf(".");
        if (idx != -1) {
            String newKey = null;
            String prop = null;
            if (aTextName.startsWith("invalid.fieldvalue.")) {
                idx = aTextName.indexOf(".", "invalid.fieldvalue.".length());
                if (idx != -1) {
                    prop = aTextName.substring("invalid.fieldvalue.".length(), idx);
                    newKey = "invalid.fieldvalue." + aTextName.substring(idx + 1);
                }
            } else {
                prop = aTextName.substring(0, idx);
                newKey = aTextName.substring(idx + 1);
            }
            if (prop != null) {
                Object obj = valueStack.findValue(prop);
                try {
                    Class<?> clazz;
                    PropertyDescriptor propertyDescriptor;
                    Object actionObj = OgnlUtil.getRealTarget(prop, valueStack.getContext(), valueStack.getRoot());
                    if (actionObj != null && (propertyDescriptor = OgnlRuntime.getPropertyDescriptor(actionObj.getClass(), (String)prop)) != null && (clazz = propertyDescriptor.getPropertyType()) != null) {
                        if (obj != null) {
                            valueStack.push(obj);
                        }
                        msg = LocalizedTextUtil.findText(clazz, newKey, locale, null, args);
                        if (obj != null) {
                            valueStack.pop();
                        }
                        if (msg != null) {
                            return msg;
                        }
                    }
                }
                catch (Exception e) {
                    _log.debug((Object)("unable to find property " + prop), (Throwable)e);
                }
            }
        }
        GetDefaultMessageReturnArg result = null;
        if (indexedTextName == null) {
            result = LocalizedTextUtil.getDefaultMessage(aTextName, locale, valueStack, args, defaultMessage);
        } else {
            result = LocalizedTextUtil.getDefaultMessage(aTextName, locale, valueStack, args, null);
            if (result.message != null) {
                return result.message;
            }
            result = LocalizedTextUtil.getDefaultMessage(indexedTextName, locale, valueStack, args, defaultMessage);
        }
        if (LocalizedTextUtil.unableToFindTextForKey(result)) {
            String warn = "Unable to find text for key '" + aTextName + "' ";
            if (indexedTextName != null) {
                warn = warn + " or indexed key '" + indexedTextName + "' ";
            }
            warn = warn + "in class '" + aClass.getName() + "' and locale '" + locale + "'";
            LOG.debug((Object)warn);
        }
        return result != null ? result.message : null;
    }

    private static boolean unableToFindTextForKey(GetDefaultMessageReturnArg result) {
        if (result == null || result.message == null) {
            return true;
        }
        return !result.foundInBundle;
    }

    public static String findText(ResourceBundle bundle, String aTextName, Locale locale) {
        return LocalizedTextUtil.findText(bundle, aTextName, locale, aTextName, new Object[0]);
    }

    public static String findText(ResourceBundle bundle, String aTextName, Locale locale, String defaultMessage, Object[] args) {
        ValueStack valueStack = ActionContext.getContext().getValueStack();
        return LocalizedTextUtil.findText(bundle, aTextName, locale, defaultMessage, args, valueStack);
    }

    public static String findText(ResourceBundle bundle, String aTextName, Locale locale, String defaultMessage, Object[] args, ValueStack valueStack) {
        try {
            LocalizedTextUtil.reloadBundles();
            String message = TextParseUtil.translateVariables(bundle.getString(aTextName), valueStack);
            MessageFormat mf = LocalizedTextUtil.buildMessageFormat(message, locale);
            return mf.format(args);
        }
        catch (MissingResourceException ex) {
            GetDefaultMessageReturnArg result = LocalizedTextUtil.getDefaultMessage(aTextName, locale, valueStack, args, defaultMessage);
            if (LocalizedTextUtil.unableToFindTextForKey(result)) {
                LOG.warn((Object)("Unable to find text for key '" + aTextName + "' in ResourceBundles for locale '" + locale + "'"));
            }
            return result.message;
        }
    }

    private static GetDefaultMessageReturnArg getDefaultMessage(String key, Locale locale, ValueStack valueStack, Object[] args, String defaultMessage) {
        GetDefaultMessageReturnArg result = null;
        boolean found = true;
        if (key != null) {
            String message = LocalizedTextUtil.findDefaultText(key, locale);
            if (message == null) {
                message = defaultMessage;
                found = false;
            }
            if (message != null) {
                MessageFormat mf = LocalizedTextUtil.buildMessageFormat(TextParseUtil.translateVariables(message, valueStack), locale);
                String msg = mf.format(args);
                result = new GetDefaultMessageReturnArg(msg, found);
            }
        }
        return result;
    }

    private static String getMessage(String bundleName, Locale locale, String key, ValueStack valueStack, Object[] args) {
        ResourceBundle bundle = LocalizedTextUtil.findResourceBundle(bundleName, locale);
        if (bundle == null) {
            return null;
        }
        LocalizedTextUtil.reloadBundles();
        try {
            String message = TextParseUtil.translateVariables(bundle.getString(key), valueStack);
            MessageFormat mf = LocalizedTextUtil.buildMessageFormat(message, locale);
            return mf.format(args);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static MessageFormat buildMessageFormat(String pattern, Locale locale) {
        MessageFormatKey key = new MessageFormatKey(pattern, locale);
        MessageFormat format = (MessageFormat)messageFormats.get(key);
        if (format == null) {
            format = new MessageFormat(pattern);
            format.setLocale(locale);
            format.applyPattern(pattern);
            messageFormats.put(key, format);
        }
        return format;
    }

    private static String findMessage(Class clazz, String key, String indexedKey, Locale locale, Object[] args, Set checked, ValueStack valueStack) {
        int x;
        if (checked == null) {
            checked = new TreeSet();
        } else if (checked.contains(clazz.getName())) {
            return null;
        }
        String msg = LocalizedTextUtil.getMessage(clazz.getName(), locale, key, valueStack, args);
        if (msg != null) {
            return msg;
        }
        if (indexedKey != null && (msg = LocalizedTextUtil.getMessage(clazz.getName(), locale, indexedKey, valueStack, args)) != null) {
            return msg;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (x = 0; x < interfaces.length; ++x) {
            msg = LocalizedTextUtil.getMessage(interfaces[x].getName(), locale, key, valueStack, args);
            if (msg != null) {
                return msg;
            }
            if (indexedKey == null || (msg = LocalizedTextUtil.getMessage(interfaces[x].getName(), locale, indexedKey, valueStack, args)) == null) continue;
            return msg;
        }
        if (clazz.isInterface()) {
            interfaces = clazz.getInterfaces();
            for (x = 0; x < interfaces.length; ++x) {
                msg = LocalizedTextUtil.findMessage(interfaces[x], key, indexedKey, locale, args, checked, valueStack);
                if (msg == null) continue;
                return msg;
            }
        } else if (!clazz.equals(Object.class) && !clazz.isPrimitive()) {
            return LocalizedTextUtil.findMessage(clazz.getSuperclass(), key, indexedKey, locale, args, checked, valueStack);
        }
        return null;
    }

    private static void reloadBundles() {
        if (reloadBundles) {
            try {
                LocalizedTextUtil.clearMap(ResourceBundle.class, null, "cacheList");
                LocalizedTextUtil.clearTomcatCache();
            }
            catch (Exception e) {
                LOG.error((Object)"Could not reload resource bundles", (Throwable)e);
            }
        }
    }

    private static void clearTomcatCache() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> cl = loader.getClass();
        try {
            if ("org.apache.catalina.loader.WebappClassLoader".equals(cl.getName())) {
                LocalizedTextUtil.clearMap(cl, loader, "resourceEntries");
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("class loader " + cl.getName() + " is not tomcat loader."));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"couldn't clear tomcat cache", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearMap(Class cl, Object obj, String name) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object cache;
        Field field = cl.getDeclaredField(name);
        field.setAccessible(true);
        Object object = cache = field.get(obj);
        synchronized (object) {
            Class<?> ccl = cache.getClass();
            Method clearMethod = ccl.getMethod("clear", new Class[0]);
            clearMethod.invoke(cache, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        LocalizedTextUtil.clearDefaultResourceBundles();
        Map map = misses;
        synchronized (map) {
            misses.clear();
        }
        map = messageFormats;
        synchronized (map) {
            messageFormats.clear();
        }
    }

    static {
        LocalizedTextUtil.clearDefaultResourceBundles();
    }

    static class GetDefaultMessageReturnArg {
        String message;
        boolean foundInBundle;

        public GetDefaultMessageReturnArg(String message, boolean foundInBundle) {
            this.message = message;
            this.foundInBundle = foundInBundle;
        }
    }

    static class MessageFormatKey {
        String pattern;
        Locale locale;

        MessageFormatKey(String pattern, Locale locale) {
            this.pattern = pattern;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MessageFormatKey)) {
                return false;
            }
            MessageFormatKey messageFormatKey = (MessageFormatKey)o;
            if (this.locale != null ? !this.locale.equals(messageFormatKey.locale) : messageFormatKey.locale != null) {
                return false;
            }
            return !(this.pattern != null ? !this.pattern.equals(messageFormatKey.pattern) : messageFormatKey.pattern != null);
        }

        public int hashCode() {
            int result = this.pattern != null ? this.pattern.hashCode() : 0;
            result = 29 * result + (this.locale != null ? this.locale.hashCode() : 0);
            return result;
        }
    }
}

