/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils.server;

import com.opensearchserver.utils.server.AbstractServer;
import com.opensearchserver.utils.server.ServletApplication;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletInfo;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.cli.ParseException;

public abstract class ServletServer
extends AbstractServer {
    private final ServletApplication servletApplication;

    protected ServletServer(String defaultHostname, int defaultTcpPort, String mainJarPath, ServletApplication servletApplication, String default_datadir_name) {
        super(defaultHostname, defaultTcpPort, mainJarPath, default_datadir_name);
        this.servletApplication = servletApplication;
    }

    @Override
    public void start(int port, String hostname) throws IOException, ParseException, ServletException {
        SessionListener sessionListener;
        DeploymentInfo servletBuilder = Servlets.deployment().setClassLoader(ServletServer.class.getClassLoader()).setContextPath(this.servletApplication.contextPath).setDeploymentName(this.servletApplication.deploymentName);
        List<ServletInfo> servletInfos = this.servletApplication.getServletInfos();
        if (servletInfos != null) {
            servletBuilder.addServlets(servletInfos);
        }
        if ((sessionListener = this.servletApplication.getSessionListener()) != null) {
            servletBuilder.addSessionListener(sessionListener);
        }
        DeploymentManager manager = Servlets.defaultContainer().addDeployment(servletBuilder);
        manager.deploy();
        PathHandler path = Handlers.path((HttpHandler)Handlers.redirect((String)this.servletApplication.contextPath)).addPrefixPath(this.servletApplication.contextPath, manager.start());
        Undertow server = Undertow.builder().addHttpListener(port, hostname).setHandler((HttpHandler)path).build();
        server.start();
    }
}

