/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.opensearchserver.utils.HttpUtils;
import com.opensearchserver.utils.json.JsonMapper;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.entity.ContentType;

public class JsonHttpResponseHandler {

    public static class JsonValueTypeRefResponse<T>
    extends HttpUtils.HttpResponseHandler<T> {
        private final TypeReference<T> typeReference;

        public JsonValueTypeRefResponse(ContentType expectedContentType, TypeReference<T> typeReference, int ... expectedCodes) {
            super(expectedContentType, expectedCodes);
            this.typeReference = typeReference;
        }

        @Override
        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            super.handleResponse(response);
            return (T)JsonMapper.MAPPER.readValue(this.httpEntity.getContent(), this.typeReference);
        }
    }

    public static class JsonValueResponse<T>
    extends HttpUtils.HttpResponseHandler<T> {
        private final Class<T> jsonClass;

        public JsonValueResponse(ContentType expectedContentType, Class<T> jsonClass, int ... expectedCodes) {
            super(expectedContentType, expectedCodes);
            this.jsonClass = jsonClass;
        }

        @Override
        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            super.handleResponse(response);
            return (T)JsonMapper.MAPPER.readValue(this.httpEntity.getContent(), this.jsonClass);
        }
    }

    public static class JsonTreeResponse
    extends HttpUtils.HttpResponseHandler<JsonNode> {
        public JsonTreeResponse(ContentType expectedContentType, int ... expectedCodes) {
            super(expectedContentType, expectedCodes);
        }

        @Override
        public JsonNode handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            super.handleResponse(response);
            return JsonMapper.MAPPER.readTree(this.httpEntity.getContent());
        }
    }
}

