/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils.json;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.opensearchserver.utils.json.JsonFileFilter;
import com.opensearchserver.utils.json.JsonMapper;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;

public class DirectoryJsonManager<T> {
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final File directory;
    private final Map<String, T> instancesMap;
    private volatile Map<String, T> instancesCache;
    private final Class<T> instanceClass;

    protected DirectoryJsonManager(File directory, Class<T> instanceClass) throws JsonGenerationException, JsonMappingException, JsonParseException, IOException {
        this.instanceClass = instanceClass;
        this.directory = directory;
        this.instancesMap = new LinkedHashMap<String, T>();
        this.load();
    }

    private File getFile(String name) {
        return new File(this.directory, name + ".json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws JsonGenerationException, JsonMappingException, JsonParseException, IOException {
        try {
            File[] files = this.directory.listFiles(JsonFileFilter.INSTANCE);
            if (files == null) {
                return;
            }
            for (File file : files) {
                String name = file.getName();
                name = name.substring(0, name.length() - 5);
                this.set(name, JsonMapper.MAPPER.readValue(file, this.instanceClass));
            }
        }
        finally {
            this.buildCache();
        }
    }

    private void buildCache() {
        this.instancesCache = new LinkedHashMap<String, T>(this.instancesMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T delete(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        name = name.intern();
        this.rwl.writeLock().lock();
        try {
            this.getFile(name).delete();
            T instance = this.instancesMap.remove(name);
            this.buildCache();
            T t = instance;
            return t;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String name, T instance) throws JsonGenerationException, JsonMappingException, IOException {
        if (instance == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            return;
        }
        name = name.intern();
        this.rwl.writeLock().lock();
        try {
            JsonMapper.MAPPER.writeValue(this.getFile(name), instance);
            this.instancesMap.put(name, instance);
            this.buildCache();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public T get(String name) {
        return this.instancesCache.get(name.intern());
    }

    public Set<String> nameSet() {
        return this.instancesCache.keySet();
    }
}

