/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.opensearchserver.utils.LockUtils;
import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.io.IOUtils;

public class CassandraSession
implements Closeable {
    private final LockUtils.ReadWriteLock rwl = new LockUtils.ReadWriteLock();
    private volatile long lastUse;
    private final Cluster cluster;
    private final String keySpace;
    private Session session;

    public CassandraSession(Cluster cluster) {
        this(cluster, null);
    }

    public CassandraSession(Cluster cluster, String keySpace) {
        this.cluster = cluster;
        this.keySpace = keySpace;
        this.session = null;
        this.lastUse = System.currentTimeMillis();
    }

    public void finalize() {
        this.closeNoLock();
    }

    private void closeNoLock() {
        if (this.session != null) {
            IOUtils.closeQuietly((Closeable)this.session);
            this.session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.rwl.w.lock();
        try {
            this.closeNoLock();
        }
        finally {
            this.rwl.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        this.rwl.r.lock();
        try {
            boolean bl = this.session == null;
            return bl;
        }
        finally {
            this.rwl.r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session checkSession() {
        this.rwl.r.lock();
        try {
            this.lastUse = System.currentTimeMillis();
            if (this.session != null && !this.session.isClosed()) {
                Session session = this.session;
                return session;
            }
        }
        finally {
            this.rwl.r.unlock();
        }
        this.rwl.w.lock();
        try {
            if (this.session != null && !this.session.isClosed()) {
                Session session = this.session;
                return session;
            }
            System.out.println("Connection: " + this.keySpace);
            Session session = this.session = this.keySpace == null ? this.cluster.connect() : this.cluster.connect(this.keySpace);
            return session;
        }
        finally {
            this.rwl.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet execute(String csql, Integer fetchSize, Object ... values) {
        Session session = this.session = this.checkSession();
        synchronized (session) {
            SimpleStatement statement;
            SimpleStatement simpleStatement = statement = values != null && values.length > 0 ? new SimpleStatement(csql, values) : new SimpleStatement(csql);
            if (fetchSize != null) {
                statement.setFetchSize(fetchSize.intValue());
            }
            return this.session.execute((Statement)statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet execute(String csql, Object ... values) {
        Session session = this.session = this.checkSession();
        synchronized (session) {
            SimpleStatement statement = values != null && values.length > 0 ? new SimpleStatement(csql, values) : new SimpleStatement(csql);
            return this.session.execute((Statement)statement);
        }
    }

    long getLastUse() {
        return this.lastUse;
    }
}

