/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static final String replaceConsecutiveSpaces(String source, String replace) {
        if (StringUtils.isEmpty((CharSequence)source)) {
            return source;
        }
        StringBuilder target = new StringBuilder();
        int l = source.length();
        boolean consecutiveSpace = false;
        for (int i = 0; i < l; ++i) {
            char c = source.charAt(i);
            if (Character.isWhitespace(c)) {
                if (consecutiveSpace) continue;
                if (replace != null) {
                    target.append(replace);
                }
                consecutiveSpace = true;
                continue;
            }
            target.append(c);
            if (!consecutiveSpace) continue;
            consecutiveSpace = false;
        }
        return target.toString();
    }

    public static Pattern wildcardPattern(String s) {
        CharSequence[] esc = new CharSequence[]{"\\", ".", "(", ")", "[", "]", "+", "?", "*"};
        CharSequence[] replace = new CharSequence[]{"/", "\\.", "\\(", "\\)", "\\[", "\\]", "\\+", "\\?", ".*"};
        s = s.trim();
        int i = 0;
        for (CharSequence ch : esc) {
            s = s.replace(ch, replace[i++]);
        }
        return Pattern.compile(s);
    }

    public static final String base64encode(String text) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        return Base64.encodeBase64URLSafeString((byte[])text.getBytes("UTF-8"));
    }

    public static final String base64decode(String base64String) {
        if (StringUtils.isEmpty((CharSequence)base64String)) {
            return null;
        }
        return new String(Base64.decodeBase64((String)base64String));
    }

    public static final int compareNullValues(Object v1, Object v2) {
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        return 0;
    }

    public static final int compareNullString(String v1, String v2) {
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        return v1.compareTo(v2);
    }

    public static int compareNullHashCode(Object o1, Object o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o2.hashCode() - o1.hashCode();
    }

    public static final String leftPad(int value, int size) {
        return org.apache.commons.lang3.StringUtils.leftPad((String)Integer.toString(value), (int)size, (char)'0');
    }

    public static final String leftPad(long value, int size) {
        return org.apache.commons.lang3.StringUtils.leftPad((String)Long.toString(value), (int)size, (char)'0');
    }

    public static final String[] toStringArray(Collection<? extends Object> collection, boolean sort) {
        if (collection == null) {
            return null;
        }
        Object[] array = new String[collection.size()];
        int i = 0;
        for (Object object : collection) {
            array[i++] = object.toString();
        }
        if (sort) {
            Arrays.sort(array);
        }
        return array;
    }

    public static final CharSequence fastConcatCharSequence(CharSequence ... charSeqs) {
        if (charSeqs == null) {
            return null;
        }
        if (charSeqs.length == 1) {
            return charSeqs[0];
        }
        StringBuilder sb = new StringBuilder();
        for (CharSequence charSeq : charSeqs) {
            sb.append(charSeq);
        }
        return sb;
    }

    public static final String fastConcat(CharSequence ... charSeqs) {
        CharSequence cs = StringUtils.fastConcatCharSequence(charSeqs);
        return cs == null ? null : cs.toString();
    }

    public static void appendArray(StringBuilder sb, Object[] array) {
        for (Object object : array) {
            StringUtils.appendObject(sb, object);
        }
    }

    public static void appendCollection(StringBuilder sb, Collection<?> collection) {
        for (Object object : collection) {
            StringUtils.appendObject(sb, object);
        }
    }

    public static void appendObject(StringBuilder sb, Object object) {
        if (object instanceof Collection) {
            StringUtils.appendCollection(sb, (Collection)object);
        } else if (object instanceof Object[]) {
            StringUtils.appendArray(sb, (Object[])object);
        } else {
            sb.append(object.toString());
        }
    }

    public static final CharSequence fastConcatCharSequence(Object ... objects) {
        if (objects == null) {
            return null;
        }
        if (objects.length == 1) {
            return objects.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            if (object == null) continue;
            StringUtils.appendObject(sb, object);
        }
        return sb;
    }

    public static final String fastConcat(Object ... objects) {
        CharSequence cs = StringUtils.fastConcatCharSequence(objects);
        return cs == null ? null : cs.toString();
    }

    public static final String[] splitLines(String str) {
        return StringUtils.split((String)str, (String)LINE_SEPARATOR);
    }
}

