/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils;

import com.opensearchserver.utils.StringUtils;
import java.util.Locale;

public class LocaleUtils {
    public static Locale findLocaleISO639(String lang) {
        Locale[] locales;
        if (lang == null) {
            return null;
        }
        int l = lang.indexOf(45);
        if (l != -1) {
            lang = lang.substring(0, l);
        }
        lang = new Locale(lang).getLanguage();
        for (Locale locale : locales = Locale.getAvailableLocales()) {
            if (!locale.getLanguage().equalsIgnoreCase(lang)) continue;
            return locale;
        }
        return null;
    }

    public static final Locale findLocaleDescription(String language) {
        Locale[] locales;
        if (StringUtils.isEmpty((CharSequence)language)) {
            return null;
        }
        for (Locale locale : locales = Locale.getAvailableLocales()) {
            if (!locale.getLanguage().equalsIgnoreCase(language)) continue;
            return locale;
        }
        for (Locale locale : locales) {
            if (!locale.getDisplayName(Locale.ENGLISH).equalsIgnoreCase(language)) continue;
            return locale;
        }
        for (Locale locale : locales) {
            if (!locale.getDisplayLanguage(Locale.ENGLISH).equalsIgnoreCase(language)) continue;
            return locale;
        }
        for (Locale locale : locales) {
            if (!locale.getDisplayName().equalsIgnoreCase(language)) continue;
            return locale;
        }
        for (Locale locale : locales) {
            if (!locale.getDisplayLanguage().equalsIgnoreCase(language)) continue;
            return locale;
        }
        return null;
    }
}

