/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import javax.imageio.stream.ImageInputStream;

public class IOUtils
extends org.apache.commons.io.IOUtils {
    public static final void close(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            IOUtils.closeQuietly((Closeable)closeable);
        }
    }

    public static final void close(ImageInputStream ... closeables) {
        if (closeables == null) {
            return;
        }
        for (ImageInputStream closeable : closeables) {
            IOUtils.closeQuietly(closeable);
        }
    }

    public static final void closeQuietly(ImageInputStream closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final void close(Collection<? extends Closeable> closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            IOUtils.closeQuietly((Closeable)closeable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int copy(InputStream inputStream, File tempFile, boolean bCloseInputStream) throws IOException {
        int n;
        FileOutputStream fos = new FileOutputStream(tempFile);
        try {
            n = IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.close(fos);
            if (bCloseInputStream) {
                IOUtils.close(inputStream);
            }
            throw throwable;
        }
        IOUtils.close(fos);
        if (bCloseInputStream) {
            IOUtils.close(inputStream);
        }
        return n;
    }

    public static final StringBuilder copy(InputStream inputStream, StringBuilder sb, String charsetName, boolean bCloseInputStream) throws IOException {
        int length;
        if (inputStream == null) {
            return sb;
        }
        if (sb == null) {
            sb = new StringBuilder();
        }
        Charset charset = Charset.forName(charsetName);
        byte[] buffer = new byte[16384];
        while ((length = inputStream.read(buffer)) != -1) {
            sb.append(new String(buffer, 0, length, charset));
        }
        if (bCloseInputStream) {
            inputStream.close();
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void appendLines(File file, String ... lines) throws IOException {
        FileWriter fw = null;
        PrintWriter pw = null;
        try {
            fw = new FileWriter(file, true);
            pw = new PrintWriter(fw);
            for (String line : lines) {
                pw.println(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(fw, pw);
            throw throwable;
        }
        IOUtils.close(fw, pw);
    }
}

