/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils;

import com.opensearchserver.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.entity.ContentType;

public class HttpUtils {
    public static Integer checkStatusCodes(HttpResponse response, int ... expectedCodes) throws ClientProtocolException {
        if (response == null) {
            throw new ClientProtocolException("No response");
        }
        StatusLine statusLine = response.getStatusLine();
        if (statusLine == null) {
            throw new ClientProtocolException("Response does not contains any status");
        }
        int statusCode = statusLine.getStatusCode();
        if (expectedCodes == null) {
            return null;
        }
        for (int code : expectedCodes) {
            if (code != statusCode) continue;
            return code;
        }
        throw new HttpResponseEntityException(response, StringUtils.fastConcat("Unexpected HTTP status code: ", statusCode));
    }

    public static HttpEntity checkIsEntity(HttpResponse response, ContentType expectedContentType) throws ClientProtocolException {
        if (response == null) {
            throw new ClientProtocolException("No response");
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new ClientProtocolException("Response does not contains any content entity");
        }
        if (expectedContentType == null) {
            return entity;
        }
        ContentType contentType = ContentType.get((HttpEntity)entity);
        if (contentType == null) {
            throw new HttpResponseEntityException(response, "Unknown content type");
        }
        if (!expectedContentType.getMimeType().equals(contentType.getMimeType())) {
            throw new HttpResponseEntityException(response, StringUtils.fastConcat("Wrong content type: ", contentType.getMimeType()));
        }
        return entity;
    }

    public static class HttpResponseEntityException
    extends HttpResponseException {
        private static final long serialVersionUID = 1958648159987063347L;
        private final HttpEntity entity;

        public HttpResponseEntityException(HttpResponse response, String message) {
            super(HttpResponseEntityException.getStatusCode(response.getStatusLine()), HttpResponseEntityException.setMessage(message, response.getEntity()));
            this.entity = response.getEntity();
        }

        private static int getStatusCode(StatusLine statusLine) {
            if (statusLine == null) {
                return 0;
            }
            return statusLine.getStatusCode();
        }

        private static String setMessage(String message, HttpEntity entity) {
            if (entity == null) {
                return message;
            }
            try {
                String content = IOUtils.toString((InputStream)entity.getContent());
                if (message == null || message.isEmpty()) {
                    return content;
                }
                ContentType contentType = ContentType.get((HttpEntity)entity);
                return StringUtils.fastConcat(message, " - ", contentType == null ? "no content-type" : contentType.toString(), " - ", content);
            }
            catch (IOException | IllegalStateException e) {
                return message;
            }
        }

        public HttpEntity getEntity() {
            return this.entity;
        }
    }

    public static abstract class HttpResponseHandler<T>
    implements ResponseHandler<T> {
        private final ContentType expectedContentType;
        private final int[] expectedCodes;
        protected HttpEntity httpEntity;
        protected StatusLine statusLine;

        public HttpResponseHandler(ContentType expectedContentType, int ... expectedCodes) {
            this.expectedContentType = expectedContentType;
            this.expectedCodes = expectedCodes;
        }

        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            this.httpEntity = response.getEntity();
            this.statusLine = response.getStatusLine();
            if (this.expectedCodes != null) {
                HttpUtils.checkStatusCodes(response, this.expectedCodes);
            }
            if (this.expectedContentType != null) {
                HttpUtils.checkIsEntity(response, this.expectedContentType);
            }
            return null;
        }
    }
}

