/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils;

import com.opensearchserver.utils.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.WordUtils;

public class HtmlUtils {
    private static final Pattern removeTagPattern = Pattern.compile("<[^>]*>");
    private static final Pattern removeBrPattern1 = Pattern.compile("\\.\\p{Space}+<br\\p{Space}*/?>", 2);
    private static final Pattern removeEndTagBlockPattern1 = Pattern.compile("\\.\\p{Space}+</(p|td|div|h1|h2|h3|h4|h5|h6|hr|li|option|pre|select|table|tbody|td|textarea|tfoot|thead|th|title|tr|ul)>", 2);
    private static final Pattern removeEndTagBlockPattern2 = Pattern.compile("</(p|td|div|h1|h2|h3|h4|h5|h6|hr|li|option|pre|select|table|tbody|td|textarea|tfoot|thead|th|title|tr|ul)>", 2);
    private static final Pattern removeBrPattern2 = Pattern.compile("<br\\p{Space}*/?>", 2);
    private static final Pattern removeScriptObjectStylePattern = Pattern.compile("<(script|object|style)[^>]*>[^<]*</(script|object|style)>", 2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String removeTag(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        text = StringUtils.replaceConsecutiveSpaces(text, " ");
        Pattern pattern = removeScriptObjectStylePattern;
        synchronized (pattern) {
            text = removeScriptObjectStylePattern.matcher(text).replaceAll("");
        }
        pattern = removeBrPattern1;
        synchronized (pattern) {
            text = removeBrPattern1.matcher(text).replaceAll("</p>");
        }
        pattern = removeEndTagBlockPattern1;
        synchronized (pattern) {
            text = removeEndTagBlockPattern1.matcher(text).replaceAll("</p>");
        }
        pattern = removeEndTagBlockPattern2;
        synchronized (pattern) {
            text = removeEndTagBlockPattern2.matcher(text).replaceAll(". ");
        }
        pattern = removeBrPattern2;
        synchronized (pattern) {
            text = removeBrPattern2.matcher(text).replaceAll(". ");
        }
        pattern = removeTagPattern;
        synchronized (pattern) {
            text = removeTagPattern.matcher(text).replaceAll("");
        }
        text = StringUtils.replaceConsecutiveSpaces(text, " ");
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String removeTag(String text, String[] allowedTags) {
        Matcher matcher;
        if (allowedTags == null) {
            text = StringUtils.replaceConsecutiveSpaces(text, " ");
        }
        StringBuffer sb = new StringBuffer();
        Pattern pattern = removeTagPattern;
        synchronized (pattern) {
            matcher = removeTagPattern.matcher(text);
        }
        while (matcher.find()) {
            boolean allowed = false;
            String group = matcher.group();
            if (allowedTags != null) {
                for (String tag : allowedTags) {
                    if (!tag.equals(group)) continue;
                    allowed = true;
                    break;
                }
            }
            matcher.appendReplacement(sb, allowed ? group : "");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static final String htmlWrap(String text, int wrapLength) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        if (text.length() < wrapLength) {
            return text;
        }
        text = StringUtils.replace((String)text, (String)"&shy;", (String)"");
        return WordUtils.wrap((String)text, (int)wrapLength, (String)"&shy;", (boolean)true);
    }

    public static final String htmlWrapReduce(String text, int wrapLength, int maxSize) {
        String frag;
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        if (text.length() < maxSize) {
            return text;
        }
        text = StringUtils.replace((String)text, (String)"&shy;", (String)"");
        text = WordUtils.wrap((String)text, (int)wrapLength, (String)"\u00ad", (boolean)true);
        String[] frags = StringUtils.split((String)text, (char)'\u00ad');
        StringBuilder sb = new StringBuilder();
        int l = frags[0].length();
        for (int i = frags.length - 1; i > 0 && (l += (frag = frags[i]).length()) < maxSize; --i) {
            sb.insert(0, frag);
        }
        sb.insert(0, '\u2026');
        sb.insert(0, frags[0]);
        return sb.toString();
    }

    public static final String urlHostPathWrapReduce(String url, int maxSize) {
        boolean bHandled;
        URL u;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            return url;
        }
        String path = StringUtils.fastConcat(u.getHost(), Character.valueOf('/'), u.getPath());
        String[] frags = StringUtils.split((String)path, (char)'/');
        if (frags.length < 2) {
            return path;
        }
        int startPos = 1;
        int endPos = frags.length - 2;
        StringBuilder sbStart = new StringBuilder(frags[0]);
        StringBuilder sbEnd = new StringBuilder(frags[frags.length - 1]);
        int length = sbStart.length() + sbEnd.length();
        do {
            bHandled = false;
            if (startPos != -1 && startPos < endPos && frags[startPos].length() + length < maxSize) {
                sbStart.append('/');
                sbStart.append(frags[startPos++]);
                bHandled = true;
            }
            if (endPos == -1 || endPos <= startPos || frags[endPos].length() + length >= maxSize) continue;
            sbEnd.insert(0, '/');
            sbEnd.insert(0, frags[endPos--]);
            bHandled = true;
        } while (bHandled);
        return StringUtils.fastConcat(sbStart, "/\u2026/", sbEnd);
    }

    public static void main(String[] args) throws IOException {
        if (args != null && args.length == 2) {
            List lines = FileUtils.readLines((File)new File(args[0]));
            FileWriter fw = new FileWriter(new File(args[1]));
            PrintWriter pw = new PrintWriter(fw);
            for (String line : lines) {
                pw.println(StringEscapeUtils.unescapeHtml4((String)line));
            }
            pw.close();
            fw.close();
        }
        String text = "file://&shy;Users/ekeller/Moteur/infotoday_enterprisesearchsourcebook08/Open_on_Windows.exe";
        System.out.println(HtmlUtils.htmlWrap(text, 20));
        System.out.println(HtmlUtils.htmlWrapReduce(text, 20, 80));
        String url = "file://Users/ekeller/Moteur/infotoday_enterprisesearchsourcebook08/Open_on_Windows.exe?test=2";
        System.out.println(HtmlUtils.urlHostPathWrapReduce(url, 80));
    }
}

