/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils;

import com.opensearchserver.utils.IOUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;

public class ExceptionUtils
extends org.apache.commons.lang3.exception.ExceptionUtils {
    public static final String getLocation(StackTraceElement[] stackTrace, String prefix) {
        for (StackTraceElement element : stackTrace) {
            if (!element.getClassName().startsWith(prefix)) continue;
            return element.toString();
        }
        return null;
    }

    public static final String getFirstLocation(StackTraceElement[] stackTrace) {
        for (StackTraceElement element : stackTrace) {
            String ele = element.toString();
            if (ele == null || ele.length() <= 0) continue;
            return ele;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getFullStackTrace(StackTraceElement[] stackTrace) {
        String string;
        StringWriter sw = null;
        PrintWriter pw = null;
        try {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            for (StackTraceElement element : stackTrace) {
                pw.println(element);
            }
            string = sw.toString();
        }
        catch (Throwable throwable) {
            IOUtils.close(pw, sw);
            throw throwable;
        }
        IOUtils.close(pw, sw);
        return string;
    }

    public static <T extends Exception> T throwException(Exception exception, Class<T> exceptionClass) throws T {
        if (exception == null) {
            return null;
        }
        if (exceptionClass.isInstance(exception)) {
            throw exception;
        }
        try {
            return (T)((Exception)exceptionClass.getConstructor(Exception.class).newInstance(exception));
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Exception getCauseIfException(Exception e) {
        if (e == null) {
            return null;
        }
        Throwable cause = e.getCause();
        return cause instanceof Exception ? (Exception)cause : e;
    }
}

