/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.utils;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.codec.binary.StringUtils;

public class CharsetUtils {
    public static final Charset CharsetUTF8 = Charset.forName("UTF-8");

    public static final String charsetDetector(InputStream inputStream) throws IOException {
        CharsetDetector detector = new CharsetDetector();
        detector.setText(inputStream);
        CharsetMatch match = detector.detect();
        if (match == null) {
            return null;
        }
        return match.getName();
    }

    public static final String charsetDetector(byte[] bytes) {
        CharsetDetector detector = new CharsetDetector();
        detector.setText(bytes);
        CharsetMatch match = detector.detect();
        if (match == null) {
            return null;
        }
        return match.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CharsetEncoder newUTF8Encoder() {
        Charset charset = CharsetUTF8;
        synchronized (charset) {
            return CharsetUTF8.newEncoder();
        }
    }

    public final byte[] encode(String test) {
        return StringUtils.getBytesUtf8((String)test);
    }
}

