/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.client.common;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.DetectorFactory;
import com.cybozu.labs.langdetect.LangDetectException;
import com.opensearchserver.utils.IOUtils;
import com.opensearchserver.utils.LocaleUtils;
import com.opensearchserver.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;

public enum LanguageEnum {
    UNDEFINED("Undefined", ""),
    ARABIC("Arabic", "ar"),
    CHINESE("Chinese", "zh", "zh-cn"),
    DANISH("Danish", "da"),
    CZECH("Czech", "cz", "cs"),
    DUTCH("Dutch", "nl"),
    ENGLISH("English", "en"),
    FINNISH("Finnish", "fi"),
    FRENCH("French", "fr"),
    GERMAN("German", "de"),
    HUNGARIAN("Hungarian", "hu"),
    ITALIAN("Italian", "it"),
    JAPANESE("Japanese", "ja"),
    KOREAN("Korean", "kr", "ko"),
    NORWEGIAN("Norwegian", "no"),
    POLISH("Polish", "pl"),
    PORTUGUESE("Portuguese", "pt"),
    ROMANIAN("Romanian", "ro"),
    RUSSIAN("Russian", "ru"),
    SPANISH("Spanish", "es"),
    SWEDISH("Swedish", "sv"),
    TURKISH("Turkish", "tr");

    private final String name;
    private final String code;
    private final String alternativeCode;

    private LanguageEnum(String name, String code, String alternativeCode) {
        this.name = name;
        this.code = code;
        this.alternativeCode = alternativeCode;
    }

    private LanguageEnum(String name, String code) {
        this(name, code, null);
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getAlternativeCode() {
        return this.alternativeCode;
    }

    public static LanguageEnum findByCode(String code) {
        if (code == null) {
            return UNDEFINED;
        }
        for (LanguageEnum lang : LanguageEnum.values()) {
            if (!code.equalsIgnoreCase(lang.code)) continue;
            return lang;
        }
        return UNDEFINED;
    }

    public static LanguageEnum findByName(String name) {
        if (name == null) {
            return UNDEFINED;
        }
        for (LanguageEnum lang : LanguageEnum.values()) {
            if (!name.equalsIgnoreCase(lang.name)) continue;
            return lang;
        }
        return UNDEFINED;
    }

    public static LanguageEnum findByNameOrCode(String nameOrCode) {
        if (nameOrCode == null) {
            return UNDEFINED;
        }
        LanguageEnum lang = LanguageEnum.findByName(nameOrCode);
        if (lang != UNDEFINED) {
            return lang;
        }
        return LanguageEnum.findByCode(nameOrCode);
    }

    public static String[] stringArray() {
        String[] array = new String[LanguageEnum.values().length];
        int i = 0;
        for (LanguageEnum lang : LanguageEnum.values()) {
            array[i++] = lang.name;
        }
        return array;
    }

    public static final Locale langDetection(String text, int length) throws LangDetectException {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        Detector detector = DetectorFactory.create();
        detector.setMaxTextLength(length);
        detector.append(text);
        String lang = detector.detect();
        return LocaleUtils.findLocaleDescription((String)lang);
    }

    static {
        try {
            ArrayList<String> profiles = new ArrayList<String>(0);
            for (LanguageEnum le : LanguageEnum.values()) {
                if (le == UNDEFINED) continue;
                InputStream is = Detector.class.getResourceAsStream("/profiles/" + le.getCode());
                if (is == null && le.getAlternativeCode() != null) {
                    is = Detector.class.getResourceAsStream("/profiles/" + le.getAlternativeCode());
                }
                if (is == null) {
                    System.err.println("No profile for lang " + le.getName());
                    continue;
                }
                profiles.add(IOUtils.toString((InputStream)is));
                is.close();
            }
            DetectorFactory.loadProfile(profiles);
        }
        catch (LangDetectException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

