/*
 * Decompiled with CFR 0.152.
 */
package com.opensearchserver.client.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.opensearchserver.utils.json.JsonHttpResponseHandler;
import com.opensearchserver.utils.json.JsonMapper;
import com.opensearchserver.utils.json.ServerResource;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;

public abstract class JsonClientAbstract {
    protected final URI uri;
    protected final String login;
    protected final String key;
    protected final int msTimeOut;

    public JsonClientAbstract(String url, String login, String key, int msTimeOut) throws URISyntaxException {
        URI u = new URI(url);
        String path = u.getPath();
        this.uri = path.endsWith("/") ? new URI(u.getScheme(), null, u.getHost(), u.getPort(), path.substring(0, path.length() - 1), u.getQuery(), u.getFragment()) : u;
        this.login = login;
        this.key = key;
        this.msTimeOut = msTimeOut;
    }

    public JsonClientAbstract(ServerResource serverResource) throws URISyntaxException {
        this(serverResource.url, serverResource.login, serverResource.api_key, serverResource.time_out);
    }

    public abstract URIBuilder getBaseUrl(String ... var1) throws URISyntaxException;

    public final <T> T execute(Request request, Object bodyObject, Integer msTimeOut, Class<T> jsonResultClass, int ... expectedCodes) throws IOException {
        if (msTimeOut == null) {
            msTimeOut = this.msTimeOut;
        }
        if (bodyObject != null) {
            request = request.bodyString(JsonMapper.MAPPER.writeValueAsString(bodyObject), ContentType.APPLICATION_JSON);
        }
        JsonHttpResponseHandler.JsonValueResponse responseHandler = new JsonHttpResponseHandler.JsonValueResponse(ContentType.APPLICATION_JSON, jsonResultClass, expectedCodes);
        return (T)request.connectTimeout(msTimeOut.intValue()).socketTimeout(msTimeOut.intValue()).addHeader("accept", ContentType.APPLICATION_JSON.toString()).execute().handleResponse((ResponseHandler)responseHandler);
    }

    public final <T> T execute(Request request, Object bodyObject, Integer msTimeOut, TypeReference<T> typeRef, int ... expectedCodes) throws IOException {
        if (msTimeOut == null) {
            msTimeOut = this.msTimeOut;
        }
        if (bodyObject != null) {
            request = request.bodyString(JsonMapper.MAPPER.writeValueAsString(bodyObject), ContentType.APPLICATION_JSON);
        }
        return (T)request.connectTimeout(msTimeOut.intValue()).socketTimeout(msTimeOut.intValue()).addHeader("accept", ContentType.APPLICATION_JSON.toString()).execute().handleResponse((ResponseHandler)new JsonHttpResponseHandler.JsonValueTypeRefResponse(ContentType.APPLICATION_JSON, typeRef, expectedCodes));
    }

    public final HttpResponse execute(Request request, Object bodyObject, Integer msTimeOut) throws IOException {
        if (msTimeOut == null) {
            msTimeOut = this.msTimeOut;
        }
        if (bodyObject != null) {
            request = bodyObject instanceof String ? request.bodyString(bodyObject.toString(), ContentType.TEXT_PLAIN) : request.bodyString(JsonMapper.MAPPER.writeValueAsString(bodyObject), ContentType.APPLICATION_JSON);
        }
        return request.connectTimeout(msTimeOut.intValue()).socketTimeout(msTimeOut.intValue()).execute().returnResponse();
    }
}

