/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.pdfboxout.BookmarkElement;
import com.openhtmltopdf.pdfboxout.PdfBoxImageElement;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.simple.extend.FormSubmissionListener;
import org.w3c.dom.Element;

public class PdfBoxReplacedElementFactory
implements ReplacedElementFactory {
    private PdfBoxOutputDevice _outputDevice;

    public PdfBoxReplacedElementFactory(PdfBoxOutputDevice outputDevice) {
        this._outputDevice = outputDevice;
    }

    public ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        String nodeName = e.getNodeName();
        if (nodeName.equals("img")) {
            FSImage fsImage;
            String srcAttr = e.getAttribute("src");
            if (srcAttr != null && srcAttr.length() > 0 && (fsImage = uac.getImageResource(srcAttr).getImage()) != null) {
                if (cssWidth != -1 || cssHeight != -1) {
                    fsImage.scale(cssWidth, cssHeight);
                }
                return new PdfBoxImageElement(fsImage);
            }
        } else if (nodeName.equals("input")) {
            String type = e.getAttribute("type");
        } else if (nodeName.equals("bookmark")) {
            BookmarkElement result = new BookmarkElement();
            if (e.hasAttribute("name")) {
                String name = e.getAttribute("name");
                c.addBoxId(name, (Box)box);
                result.setAnchorName(name);
            }
            return result;
        }
        return null;
    }

    public void setFormSubmissionListener(FormSubmissionListener listener) {
    }

    public void reset() {
    }

    public void remove(Element e) {
    }
}

