/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.SimpleBidiReorderer;
import com.openhtmltopdf.context.StyleReference;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FontContext;
import com.openhtmltopdf.extend.FontResolver;
import com.openhtmltopdf.extend.HttpStreamFactory;
import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.extend.TextRenderer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.extend.UserInterface;
import com.openhtmltopdf.layout.BoxBuilder;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.PDFCreationListener;
import com.openhtmltopdf.pdfboxout.PdfBoxFontContext;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxReplacedElementFactory;
import com.openhtmltopdf.pdfboxout.PdfBoxTextRenderer;
import com.openhtmltopdf.pdfboxout.PdfBoxUserAgent;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.ViewportBox;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.simple.extend.XhtmlNamespaceHandler;
import com.openhtmltopdf.util.Configuration;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class PdfBoxRenderer {
    private static final float DEFAULT_DOTS_PER_POINT = 26.666666f;
    private static final int DEFAULT_DOTS_PER_PIXEL = 20;
    private final SharedContext _sharedContext;
    private final PdfBoxOutputDevice _outputDevice;
    private Document _doc;
    private BlockBox _root;
    private final float _dotsPerPoint;
    private PDDocument _pdfDoc = new PDDocument();
    private PDEncryption _pdfEncryption;
    private float _pdfVersion;
    private boolean _testMode;
    private PDFCreationListener _listener;
    private OutputStream _os;
    private BidiSplitterFactory _splitterFactory;
    private byte _defaultTextDirection = 0;
    private BidiReorderer _reorderer;

    public PdfBoxRenderer(boolean testMode) {
        this(26.666666f, 20, true, testMode, null);
    }

    public PdfBoxRenderer(float dotsPerPoint, int dotsPerPixel, boolean useSubsets, boolean testMode, HttpStreamFactory factory) {
        this._dotsPerPoint = dotsPerPoint;
        this._testMode = testMode;
        this._outputDevice = new PdfBoxOutputDevice(dotsPerPoint, testMode);
        this._outputDevice.setWriter(this._pdfDoc);
        PdfBoxUserAgent userAgent = new PdfBoxUserAgent(this._outputDevice);
        if (factory != null) {
            userAgent.setHttpStreamFactory(factory);
        }
        this._sharedContext = new SharedContext();
        this._sharedContext.setUserAgentCallback((UserAgentCallback)userAgent);
        this._sharedContext.setCss(new StyleReference((UserAgentCallback)userAgent));
        userAgent.setSharedContext(this._sharedContext);
        this._outputDevice.setSharedContext(this._sharedContext);
        PdfBoxFontResolver fontResolver = new PdfBoxFontResolver(this._sharedContext, this._pdfDoc, useSubsets);
        this._sharedContext.setFontResolver((FontResolver)fontResolver);
        PdfBoxReplacedElementFactory replacedElementFactory = new PdfBoxReplacedElementFactory(this._outputDevice);
        this._sharedContext.setReplacedElementFactory((ReplacedElementFactory)replacedElementFactory);
        this._sharedContext.setTextRenderer((TextRenderer)new PdfBoxTextRenderer());
        this._sharedContext.setDPI(72.0f * this._dotsPerPoint);
        this._sharedContext.setDotsPerPixel(dotsPerPixel);
        this._sharedContext.setPrint(true);
        this._sharedContext.setInteractive(false);
    }

    public PdfBoxRenderer(boolean textDirection, boolean testMode, boolean useSubsets, HttpStreamFactory httpStreamFactory, BidiSplitterFactory splitterFactory, BidiReorderer reorderer, String html, Document document, String baseUri, String uri, File file, OutputStream os) {
        this(26.666666f, 20, useSubsets, testMode, httpStreamFactory);
        if (splitterFactory != null) {
            this.setBidiSplitter(splitterFactory);
        }
        if (reorderer != null) {
            this.setBidiReorderer(reorderer);
        }
        if (html != null) {
            this.setDocumentFromString(html, baseUri);
        } else if (document != null) {
            this.setDocument(document, baseUri);
        } else if (uri != null) {
            this.setDocument(uri);
        } else if (file != null) {
            try {
                this.setDocument(file);
            }
            catch (IOException e) {
                throw new RuntimeException("File IO problem", e);
            }
        }
        this._os = os;
    }

    public Document getDocument() {
        return this._doc;
    }

    public void setBidiSplitter(BidiSplitterFactory splitterFactory) {
        this._splitterFactory = splitterFactory;
    }

    public void setBidiReorderer(BidiReorderer reorderer) {
        this._reorderer = reorderer;
        this._outputDevice.setBidiReorderer(reorderer);
    }

    public void setDefaultTextDirection(boolean rtl) {
        this._defaultTextDirection = rtl ? (byte)1 : 0;
    }

    public PdfBoxFontResolver getFontResolver() {
        return (PdfBoxFontResolver)this._sharedContext.getFontResolver();
    }

    private Document loadDocument(String uri) {
        return this._sharedContext.getUac().getXMLResource(uri).getDocument();
    }

    public void setDocument(String uri) {
        this.setDocument(this.loadDocument(uri), uri);
    }

    public void setDocument(Document doc, String url) {
        this.setDocument(doc, url, (NamespaceHandler)new XhtmlNamespaceHandler());
    }

    public void setDocument(File file) throws IOException {
        File parent = file.getAbsoluteFile().getParentFile();
        this.setDocument(this.loadDocument(file.toURI().toURL().toExternalForm()), parent == null ? "" : parent.toURI().toURL().toExternalForm());
    }

    public void setDocumentFromString(String content) {
        this.setDocumentFromString(content, null);
    }

    public void setDocumentFromString(String content, String baseUrl) {
        InputSource is = new InputSource(new BufferedReader(new StringReader(content)));
        Document dom = XMLResource.load((InputSource)is).getDocument();
        this.setDocument(dom, baseUrl);
    }

    public void setDocument(Document doc, String url, NamespaceHandler nsh) {
        this._doc = doc;
        this.getFontResolver().flushFontFaceFonts();
        this._sharedContext.reset();
        if (Configuration.isTrue((String)"xr.cache.stylesheets", (boolean)true)) {
            this._sharedContext.getCss().flushStyleSheets();
        } else {
            this._sharedContext.getCss().flushAllStyleSheets();
        }
        this._sharedContext.setBaseURL(url);
        this._sharedContext.setNamespaceHandler(nsh);
        this._sharedContext.getCss().setDocumentContext(this._sharedContext, this._sharedContext.getNamespaceHandler(), doc, (UserInterface)new NullUserInterface());
        this.getFontResolver().importFontFaces(this._sharedContext.getCss().getFontFaceRules());
    }

    public PDEncryption getPDFEncryption() {
        return this._pdfEncryption;
    }

    public void setPDFEncryption(PDEncryption pdfEncryption) {
        this._pdfEncryption = pdfEncryption;
    }

    public void setPDFVersion(float v) {
        this._pdfDoc.setVersion(v);
        this._pdfVersion = v;
    }

    public float getPDFVersion() {
        return this._pdfVersion == 0.0f ? 1.7f : this._pdfVersion;
    }

    public void layout() {
        LayoutContext c = this.newLayoutContext();
        BlockBox root = BoxBuilder.createRootBox((LayoutContext)c, (Document)this._doc);
        root.setContainingBlock((Box)new ViewportBox(this.getInitialExtents(c)));
        root.layout(c);
        Dimension dim = root.getLayer().getPaintingDimension(c);
        root.getLayer().trimEmptyPages((CssContext)c, dim.height);
        root.getLayer().layoutPages(c);
        this._root = root;
    }

    private Rectangle getInitialExtents(LayoutContext c) {
        PageBox first = Layer.createPageBox((CssContext)c, (String)"first");
        return new Rectangle(0, 0, first.getContentWidth((CssContext)c), first.getContentHeight((CssContext)c));
    }

    private RenderingContext newRenderingContext() {
        RenderingContext result = this._sharedContext.newRenderingContextInstance();
        result.setFontContext((FontContext)new PdfBoxFontContext());
        result.setOutputDevice((OutputDevice)this._outputDevice);
        if (this._reorderer != null) {
            result.setBidiReorderer(this._reorderer);
        }
        this._outputDevice.setRenderingContext(result);
        this._sharedContext.getTextRenderer().setup(result.getFontContext());
        result.setRootLayer(this._root.getLayer());
        return result;
    }

    private LayoutContext newLayoutContext() {
        LayoutContext result = this._sharedContext.newLayoutContextInstance();
        result.setFontContext((FontContext)new PdfBoxFontContext());
        if (this._splitterFactory != null) {
            result.setBidiSplitterFactory(this._splitterFactory);
        }
        if (this._reorderer != null) {
            result.setBidiReorderer(this._reorderer);
        }
        result.setDefaultTextDirection(this._defaultTextDirection);
        ((PdfBoxTextRenderer)this._sharedContext.getTextRenderer()).setup(result.getFontContext(), (BidiReorderer)(this._reorderer != null ? this._reorderer : new SimpleBidiReorderer()));
        return result;
    }

    public void createPDF() throws IOException {
        this.createPDF(this._os);
    }

    public void createPDF(OutputStream os) throws IOException {
        this.createPDF(os, true, 0);
    }

    public void writeNextDocument() throws IOException {
        this.writeNextDocument(0);
    }

    public void writeNextDocument(int initialPageNo) throws IOException {
        List pages = this._root.getLayer().getPages();
        RenderingContext c = this.newRenderingContext();
        c.setInitialPageNo(initialPageNo);
        PageBox firstPage = (PageBox)pages.get(0);
        Rectangle2D.Float firstPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)firstPage.getWidth((CssContext)c) / this._dotsPerPoint, (float)firstPage.getHeight((CssContext)c) / this._dotsPerPoint);
        this._outputDevice.setStartPageNo(this._pdfDoc.getNumberOfPages());
        this.writePDF(pages, c, firstPageSize, this._pdfDoc);
    }

    public void finishPDF() throws IOException {
        if (this._pdfDoc != null) {
            this.fireOnClose();
            this._pdfDoc.close();
        }
    }

    public void createPDF(OutputStream os, boolean finish) throws IOException {
        this.createPDF(os, finish, 0);
    }

    public void createPDF(OutputStream os, boolean finish, int initialPageNo) throws IOException {
        List pages = this._root.getLayer().getPages();
        RenderingContext c = this.newRenderingContext();
        c.setInitialPageNo(initialPageNo);
        PageBox firstPage = (PageBox)pages.get(0);
        Rectangle2D.Float firstPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)firstPage.getWidth((CssContext)c) / this._dotsPerPoint, (float)firstPage.getHeight((CssContext)c) / this._dotsPerPoint);
        if (this._pdfVersion != 0.0f) {
            this._pdfDoc.setVersion(this._pdfVersion);
        }
        if (this._pdfEncryption != null) {
            this._pdfDoc.setEncryptionDictionary(this._pdfEncryption);
        }
        this.firePreOpen();
        this.writePDF(pages, c, firstPageSize, this._pdfDoc);
        if (finish) {
            this.fireOnClose();
            this._pdfDoc.save(os);
            this._pdfDoc.close();
        }
    }

    private void firePreOpen() {
        if (this._listener != null) {
            this._listener.preOpen(this);
        }
    }

    private void firePreWrite(int pageCount) {
        if (this._listener != null) {
            this._listener.preWrite(this, pageCount);
        }
    }

    private void fireOnClose() {
        if (this._listener != null) {
            this._listener.onClose(this);
        }
    }

    private void writePDF(List pages, RenderingContext c, Rectangle2D firstPageSize, PDDocument doc) throws IOException {
        this._outputDevice.setRoot((Box)this._root);
        this._outputDevice.start(this._doc);
        PDPage page = new PDPage(new PDRectangle((float)firstPageSize.getWidth(), (float)firstPageSize.getHeight()));
        PDPageContentStream cs = new PDPageContentStream(doc, page, false, !this._testMode);
        doc.addPage(page);
        this._outputDevice.initializePage(cs, page, (float)firstPageSize.getHeight());
        this._root.getLayer().assignPagePaintingPositions((CssContext)c, (short)2);
        int pageCount = this._root.getLayer().getPages().size();
        c.setPageCount(pageCount);
        this.firePreWrite(pageCount);
        this.setDidValues(doc);
        for (int i = 0; i < pageCount; ++i) {
            PageBox currentPage = (PageBox)pages.get(i);
            c.setPage(i, currentPage);
            this.paintPage(c, currentPage);
            this._outputDevice.finishPage();
            if (i == pageCount - 1) continue;
            PageBox nextPage = (PageBox)pages.get(i + 1);
            Rectangle2D.Float nextPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)nextPage.getWidth((CssContext)c) / this._dotsPerPoint, (float)nextPage.getHeight((CssContext)c) / this._dotsPerPoint);
            PDPage pageNext = new PDPage(new PDRectangle((float)firstPageSize.getWidth(), (float)firstPageSize.getHeight()));
            PDPageContentStream csNext = new PDPageContentStream(doc, pageNext, false, !this._testMode);
            doc.addPage(pageNext);
            this._outputDevice.initializePage(csNext, pageNext, (float)((RectangularShape)nextPageSize).getHeight());
        }
        this._outputDevice.finish(c, (Box)this._root);
    }

    private void setDidValues(PDDocument doc) {
        String v = this._outputDevice.getMetadataByName("title");
        PDDocumentInformation info = new PDDocumentInformation();
        if (v != null) {
            info.setTitle(v);
        }
        if ((v = this._outputDevice.getMetadataByName("author")) != null) {
            info.setAuthor(v);
        }
        if ((v = this._outputDevice.getMetadataByName("subject")) != null) {
            info.setSubject(v);
        }
        if ((v = this._outputDevice.getMetadataByName("keywords")) != null) {
            info.setKeywords(v);
        }
        doc.setDocumentInformation(info);
    }

    private void paintPage(RenderingContext c, PageBox page) throws IOException {
        page.paintBackground(c, 0, (short)2);
        page.paintMarginAreas(c, 0, (short)2);
        page.paintBorder(c, 0, (short)2);
        Shape working = this._outputDevice.getClip();
        Rectangle content = page.getPrintClippingBounds((CssContext)c);
        this._outputDevice.clip(content);
        int top = -page.getPaintingTop() + page.getMarginBorderPadding((CssContext)c, 3);
        int left = page.getMarginBorderPadding((CssContext)c, 1);
        this._outputDevice.translate(left, top);
        this._root.getLayer().paint(c);
        this._outputDevice.translate(-left, -top);
        this._outputDevice.setClip(working);
    }

    private String stringfyMetadata(Element element) {
        Element target = PdfBoxRenderer.getFirstChildElement(element);
        if (target == null) {
            return null;
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter output = new StringWriter();
            transformer.transform(new DOMSource(target), new StreamResult(output));
            return output.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private static Element getFirstChildElement(Element element) {
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    private String createXPacket(String metadata) {
        StringBuffer result = new StringBuffer(metadata.length() + 50);
        result.append("<?xpacket begin='\ufeff' id='W5M0MpCehiHzreSzNTczkc9d'?>\n");
        result.append(metadata);
        result.append("\n<?xpacket end='r'?>");
        return result.toString();
    }

    public PdfBoxOutputDevice getOutputDevice() {
        return this._outputDevice;
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public void exportText(Writer writer) throws IOException {
        RenderingContext c = this.newRenderingContext();
        c.setPageCount(this._root.getLayer().getPages().size());
        this._root.exportText(c, writer);
    }

    public BlockBox getRootBox() {
        return this._root;
    }

    public float getDotsPerPoint() {
        return this._dotsPerPoint;
    }

    public List findPagePositionsByID(Pattern pattern) {
        return this._outputDevice.findPagePositionsByID((CssContext)this.newLayoutContext(), pattern);
    }

    public PDFCreationListener getListener() {
        return this._listener;
    }

    public void setListener(PDFCreationListener listener) {
        this._listener = listener;
    }

    private static final class NullUserInterface
    implements UserInterface {
        private NullUserInterface() {
        }

        public boolean isHover(Element e) {
            return false;
        }

        public boolean isActive(Element e) {
            return false;
        }

        public boolean isFocus(Element e) {
            return false;
        }
    }
}

