/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.SimpleBidiReorderer;
import com.openhtmltopdf.css.parser.FSCMYKColor;
import com.openhtmltopdf.css.parser.FSColor;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.pdfboxout.DOMUtil;
import com.openhtmltopdf.pdfboxout.PagePosition;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFont;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxImage;
import com.openhtmltopdf.pdfboxout.PdfBoxLinkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxReplacedElement;
import com.openhtmltopdf.pdfboxout.PdfBoxTextRenderer;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.render.AbstractOutputDevice;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.render.InlineLayoutBox;
import com.openhtmltopdf.render.InlineText;
import com.openhtmltopdf.render.JustificationInfo;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.util.Configuration;
import com.openhtmltopdf.util.XRLog;
import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitHeightDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PdfBoxOutputDevice
extends AbstractOutputDevice
implements OutputDevice {
    private static final int FILL = 1;
    private static final int STROKE = 2;
    private static final int CLIP = 3;
    private static final AffineTransform IDENTITY = new AffineTransform();
    private static final BasicStroke STROKE_ONE = new BasicStroke(1.0f);
    private static final boolean ROUND_RECT_DIMENSIONS_DOWN = Configuration.isTrue((String)"xr.pdf.round.rect.dimensions.down", (boolean)false);
    private PDPage _page;
    private PdfContentStreamAdapter _cp;
    private float _pageHeight;
    private PdfBoxFSFont _font;
    private AffineTransform _transform = new AffineTransform();
    private FSColor _color = FSRGBColor.BLACK;
    private FSColor _fillColor;
    private FSColor _strokeColor;
    private Stroke _stroke = null;
    private Stroke _originalStroke = null;
    private Stroke _oldStroke = null;
    private Area _clip;
    private SharedContext _sharedContext;
    private float _dotsPerPoint;
    private PDDocument _writer;
    private Map _readerCache = new HashMap();
    private PDDestination _defaultDestination;
    private List _bookmarks = new ArrayList();
    private List _metadata = new ArrayList();
    private Box _root;
    private int _startPageNo;
    private int _nextFormFieldIndex;
    private final boolean _testMode;
    private PdfBoxLinkManager _linkManager;
    private RenderingContext _renderingContext;
    private BidiReorderer _reorderer = new SimpleBidiReorderer();

    public PdfBoxOutputDevice(float dotsPerPoint, boolean testMode) {
        this._dotsPerPoint = dotsPerPoint;
        this._testMode = testMode;
    }

    public void setWriter(PDDocument writer) {
        this._writer = writer;
    }

    public PDDocument getWriter() {
        return this._writer;
    }

    public int getNextFormFieldIndex() {
        return ++this._nextFormFieldIndex;
    }

    public void initializePage(PDPageContentStream currentPage, PDPage page, float height) {
        this._cp = new PdfContentStreamAdapter(currentPage);
        this._page = page;
        this._pageHeight = height;
        this._cp.saveGraphics();
        this._transform = new AffineTransform();
        this._transform.scale(1.0 / (double)this._dotsPerPoint, 1.0 / (double)this._dotsPerPoint);
        this._originalStroke = this._stroke = this.transformStroke(STROKE_ONE);
        this._oldStroke = this._stroke;
        this.setStrokeDiff(this._stroke, null);
        if (this._defaultDestination == null) {
            PDPageFitHeightDestination dest = new PDPageFitHeightDestination();
            dest.setPage(page);
        }
    }

    public void finishPage() {
        this._cp.restoreGraphics();
        this._cp.closeContent();
    }

    public void paintReplacedElement(RenderingContext c, BlockBox box) {
        PdfBoxReplacedElement element = (PdfBoxReplacedElement)box.getReplacedElement();
        element.paint(c, this, box);
    }

    public void paintBackground(RenderingContext c, Box box) {
        super.paintBackground(c, box);
        this._linkManager.processLinkLater(c, box, this._page, this._pageHeight, this._transform);
    }

    public float getDeviceLength(float length) {
        return length / this._dotsPerPoint;
    }

    public void drawBorderLine(Shape bounds, int side, int lineWidth, boolean solid) {
        this.draw(bounds);
    }

    public void setColor(FSColor color) {
        if (color instanceof FSRGBColor) {
            this._color = color;
        } else if (color instanceof FSCMYKColor) {
            this._color = color;
        } else assert (this._color instanceof FSRGBColor || this._color instanceof FSCMYKColor);
    }

    public void draw(Shape s) {
        this.followPath(s, 2);
    }

    protected void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        this.draw(line);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.draw(new Rectangle(x, y, width, height));
    }

    public void drawOval(int x, int y, int width, int height) {
        Ellipse2D.Float oval = new Ellipse2D.Float(x, y, width, height);
        this.draw(oval);
    }

    public void fill(Shape s) {
        this.followPath(s, 1);
    }

    public void fillRect(int x, int y, int width, int height) {
        if (ROUND_RECT_DIMENSIONS_DOWN) {
            this.fill(new Rectangle(x, y, width - 1, height - 1));
        } else {
            this.fill(new Rectangle(x, y, width, height));
        }
    }

    public void fillOval(int x, int y, int width, int height) {
        Ellipse2D.Float oval = new Ellipse2D.Float(x, y, width, height);
        this.fill(oval);
    }

    public void translate(double tx, double ty) {
        this._transform.translate(tx, ty);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    public void setRenderingHint(RenderingHints.Key key, Object value) {
    }

    public void setFont(FSFont font) {
        this._font = (PdfBoxFSFont)font;
    }

    private AffineTransform normalizeMatrix(AffineTransform current) {
        double[] mx = new double[6];
        AffineTransform result = new AffineTransform();
        result.getMatrix(mx);
        mx[3] = -1.0;
        mx[5] = this._pageHeight;
        result = new AffineTransform(mx);
        result.concatenate(current);
        return result;
    }

    public void drawString(String s, float x, float y, JustificationInfo info) {
        PDFont firstFont = this._font.getFontDescription().get(0).getFont();
        try {
            firstFont.getStringWidth(s);
            this.drawStringFast(s, x, y, info, this._font.getFontDescription().get(0), this._font.getSize2D());
            return;
        }
        catch (Exception e) {
            List<FontRun> fontRuns = this.replaceCharacters(this._font, s, this._reorderer);
            float xOffset = 0.0f;
            for (FontRun run : fontRuns) {
                this.drawStringFast(run.str, x + xOffset, y, info, run.des, this._font.getSize2D());
                try {
                    xOffset += run.des.getFont().getStringWidth(run.str) / 1000.0f * this._font.getSize2D();
                }
                catch (Exception e2) {
                    XRLog.render((Level)Level.WARNING, (String)"BUG. Font didn't contain expected character.", (Throwable)e2);
                }
            }
            return;
        }
    }

    public void drawStringFast(String s, float x, float y, JustificationInfo info, PdfBoxFontResolver.FontDescription desc, float fontSize) {
        if (s.length() == 0) {
            return;
        }
        this.ensureFillColor();
        AffineTransform at = (AffineTransform)this.getTransform().clone();
        at.translate(x, y);
        AffineTransform inverse = this.normalizeMatrix(at);
        AffineTransform flipper = AffineTransform.getScaleInstance(1.0, -1.0);
        inverse.concatenate(flipper);
        inverse.scale(this._dotsPerPoint, this._dotsPerPoint);
        double[] mx = new double[6];
        inverse.getMatrix(mx);
        float b = (float)mx[1];
        float c = (float)mx[2];
        this._cp.beginText();
        this._cp.setFont(desc.getFont(), fontSize /= this._dotsPerPoint);
        this._cp.setTextMatrix((float)mx[0], b, c, (float)mx[3], (float)mx[4], (float)mx[5]);
        if (info != null) {
            this._cp.setTextSpacing(info.getNonSpaceAdjust());
            this._cp.setSpaceSpacing(info.getSpaceAdjust());
        }
        this._cp.drawString(s);
        this._cp.endText();
    }

    private List<FontRun> replaceCharacters(FSFont font, String str, BidiReorderer reorderer) {
        StringBuilder sb = new StringBuilder();
        PdfBoxTextRenderer.ReplacementChar replace = PdfBoxTextRenderer.getReplacementChar(font);
        List<PdfBoxFontResolver.FontDescription> fonts = ((PdfBoxFSFont)font).getFontDescription();
        ArrayList<FontRun> runs = new ArrayList<FontRun>();
        FontRun current = new FontRun();
        int i = 0;
        while (i < str.length()) {
            int unicode = str.codePointAt(i);
            i += Character.charCount(unicode);
            String ch = String.valueOf(Character.toChars(unicode));
            boolean gotChar = false;
            for (PdfBoxFontResolver.FontDescription des : fonts) {
                try {
                    des.getFont().getStringWidth(ch);
                    if (current.des == null) {
                        current.des = des;
                    } else if (des != current.des) {
                        current.str = sb.toString();
                        runs.add(current);
                        current = new FontRun();
                        current.des = des;
                        sb = new StringBuilder();
                    }
                    sb.append(ch);
                    gotChar = true;
                    break;
                }
                catch (Exception e1) {
                    if (!reorderer.isLiveImplementation()) continue;
                    String deshaped = reorderer.deshapeText(ch);
                    try {
                        des.getFont().getStringWidth(deshaped);
                        if (current.des == null) {
                            current.des = des;
                        } else if (des != current.des) {
                            current.str = sb.toString();
                            runs.add(current);
                            current = new FontRun();
                            current.des = des;
                            sb = new StringBuilder();
                        }
                        sb.append(deshaped);
                        gotChar = true;
                        break;
                    }
                    catch (Exception e2) {
                    }
                }
            }
            if (gotChar) continue;
            if (current.des == null) {
                current.des = replace.fontDescription;
            } else if (replace.fontDescription != current.des) {
                current.str = sb.toString();
                runs.add(current);
                current = new FontRun();
                current.des = replace.fontDescription;
                sb = new StringBuilder();
            }
            sb.append(replace.replacement);
        }
        if (sb.length() > 0) {
            current.str = sb.toString();
            runs.add(current);
        }
        return runs;
    }

    private AffineTransform getTransform() {
        return this._transform;
    }

    private void ensureFillColor() {
        if (!this._color.equals(this._fillColor)) {
            this._fillColor = this._color;
            if (this._fillColor instanceof FSRGBColor) {
                FSRGBColor rgb = (FSRGBColor)this._fillColor;
                this._cp.setFillColor(rgb.getRed(), rgb.getGreen(), rgb.getBlue());
            } else if (this._fillColor instanceof FSCMYKColor) {
                FSCMYKColor cmyk = (FSCMYKColor)this._fillColor;
                this._cp.setFillColor(cmyk.getCyan(), cmyk.getMagenta(), cmyk.getYellow(), cmyk.getBlack());
            } else assert (this._fillColor instanceof FSRGBColor || this._fillColor instanceof FSCMYKColor);
        }
    }

    private void ensureStrokeColor() {
        if (!this._color.equals(this._strokeColor)) {
            this._strokeColor = this._color;
            if (this._strokeColor instanceof FSRGBColor) {
                FSRGBColor rgb = (FSRGBColor)this._strokeColor;
                this._cp.setStrokingColor(rgb.getRed(), rgb.getGreen(), rgb.getBlue());
            } else if (this._strokeColor instanceof FSCMYKColor) {
                FSCMYKColor cmyk = (FSCMYKColor)this._strokeColor;
                this._cp.setStrokingColor(cmyk.getCyan(), cmyk.getMagenta(), cmyk.getYellow(), cmyk.getBlack());
            } else assert (this._strokeColor instanceof FSRGBColor || this._strokeColor instanceof FSCMYKColor);
        }
    }

    public PdfContentStreamAdapter getCurrentPage() {
        return this._cp;
    }

    private void followPath(Shape s, int drawType) {
        if (s == null) {
            return;
        }
        if (drawType == 2 && !(this._stroke instanceof BasicStroke)) {
            s = this._stroke.createStrokedShape(s);
            this.followPath(s, 1);
            return;
        }
        if (drawType == 2) {
            this.setStrokeDiff(this._stroke, this._oldStroke);
            this._oldStroke = this._stroke;
            this.ensureStrokeColor();
        } else if (drawType == 1) {
            this.ensureFillColor();
        }
        PathIterator points = drawType == 3 ? s.getPathIterator(IDENTITY) : s.getPathIterator(this._transform);
        float[] coords = new float[6];
        int traces = 0;
        while (!points.isDone()) {
            ++traces;
            int segtype = points.currentSegment(coords);
            this.normalizeY(coords);
            switch (segtype) {
                case 4: {
                    this._cp.closeSubpath();
                    break;
                }
                case 3: {
                    this._cp.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    this._cp.lineTo(coords[0], coords[1]);
                    break;
                }
                case 0: {
                    this._cp.moveTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this._cp.curveTo(coords[0], coords[1], coords[2], coords[3]);
                }
            }
            points.next();
        }
        switch (drawType) {
            case 1: {
                if (traces <= 0) break;
                if (points.getWindingRule() == 0) {
                    this._cp.fillEvenOdd();
                    break;
                }
                this._cp.fillNonZero();
                break;
            }
            case 2: {
                if (traces <= 0) break;
                this._cp.stroke();
                break;
            }
            default: {
                if (traces == 0) {
                    this._cp.addRect(0.0f, 0.0f, 0.0f, 0.0f);
                }
                if (points.getWindingRule() == 0) {
                    this._cp.clipEvenOdd();
                } else {
                    this._cp.clipNonZero();
                }
                this._cp.newPath();
            }
        }
    }

    private float normalizeY(float y) {
        return this._pageHeight - y;
    }

    private void normalizeY(float[] coords) {
        coords[1] = this.normalizeY(coords[1]);
        coords[3] = this.normalizeY(coords[3]);
        coords[5] = this.normalizeY(coords[5]);
    }

    private void setStrokeDiff(Stroke newStroke, Stroke oldStroke) {
        if (newStroke == oldStroke) {
            return;
        }
        if (!(newStroke instanceof BasicStroke)) {
            return;
        }
        BasicStroke nStroke = (BasicStroke)newStroke;
        boolean oldOk = oldStroke instanceof BasicStroke;
        BasicStroke oStroke = null;
        if (oldOk) {
            oStroke = (BasicStroke)oldStroke;
        }
        if (!oldOk || nStroke.getLineWidth() != oStroke.getLineWidth()) {
            this._cp.setLineWidth(nStroke.getLineWidth());
        }
        if (!oldOk || nStroke.getEndCap() != oStroke.getEndCap()) {
            switch (nStroke.getEndCap()) {
                case 0: {
                    this._cp.setLineCap(0);
                    break;
                }
                case 2: {
                    this._cp.setLineCap(2);
                    break;
                }
                default: {
                    this._cp.setLineCap(1);
                }
            }
        }
        if (!oldOk || nStroke.getLineJoin() != oStroke.getLineJoin()) {
            switch (nStroke.getLineJoin()) {
                case 0: {
                    this._cp.setLineJoin(0);
                    break;
                }
                case 2: {
                    this._cp.setLineJoin(2);
                    break;
                }
                default: {
                    this._cp.setLineJoin(1);
                }
            }
        }
        if (!oldOk || nStroke.getMiterLimit() != oStroke.getMiterLimit()) {
            this._cp.setMiterLimit(nStroke.getMiterLimit());
        }
        boolean makeDash = oldOk ? (nStroke.getDashArray() != null ? (nStroke.getDashPhase() != oStroke.getDashPhase() ? true : !Arrays.equals(nStroke.getDashArray(), oStroke.getDashArray())) : oStroke.getDashArray() != null) : true;
        if (makeDash) {
            float[] dash = nStroke.getDashArray();
            if (dash == null) {
                this._cp.setLineDash(new float[0], 0.0f);
            } else {
                this._cp.setLineDash(dash, nStroke.getDashPhase());
            }
        }
    }

    public void setStroke(Stroke s) {
        this._originalStroke = s;
        this._stroke = this.transformStroke(s);
    }

    private Stroke transformStroke(Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            return stroke;
        }
        BasicStroke st = (BasicStroke)stroke;
        float scale = (float)Math.sqrt(Math.abs(this._transform.getDeterminant()));
        float[] dash = st.getDashArray();
        if (dash != null) {
            int k = 0;
            while (k < dash.length) {
                int n = k++;
                dash[n] = dash[n] * scale;
            }
        }
        return new BasicStroke(st.getLineWidth() * scale, st.getEndCap(), st.getLineJoin(), st.getMiterLimit(), dash, st.getDashPhase() * scale);
    }

    public void clip(Shape s) {
        if (s != null) {
            s = this._transform.createTransformedShape(s);
            if (this._clip == null) {
                this._clip = new Area(s);
            } else {
                this._clip.intersect(new Area(s));
            }
            this.followPath(s, 3);
        } else assert (s != null);
    }

    public Shape getClip() {
        try {
            return this._transform.createInverse().createTransformedShape(this._clip);
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }

    public void setClip(Shape s) {
        this._cp.restoreGraphics();
        this._cp.saveGraphics();
        if (s != null) {
            s = this._transform.createTransformedShape(s);
        }
        if (s == null) {
            this._clip = null;
        } else {
            this._clip = new Area(s);
            this.followPath(s, 3);
        }
        this._fillColor = null;
        this._strokeColor = null;
        this._oldStroke = null;
    }

    public Stroke getStroke() {
        return this._originalStroke;
    }

    public void realizeImage(PdfBoxImage img) {
        PDImageXObject xobject;
        try {
            if (img.isJpeg()) {
                xobject = JPEGFactory.createFromStream((PDDocument)this._writer, (InputStream)new ByteArrayInputStream(img.getBytes()));
            } else {
                BufferedImage buffered = ImageIO.read(new ByteArrayInputStream(img.getBytes()));
                xobject = LosslessFactory.createFromImage((PDDocument)this._writer, (BufferedImage)buffered);
            }
        }
        catch (IOException e) {
            throw new PdfContentStreamAdapter.PdfException("realizeImage", e);
        }
        img.clearBytes();
        img.setXObject(xobject);
    }

    public void drawImage(FSImage fsImage, int x, int y) {
        PdfBoxImage img = (PdfBoxImage)fsImage;
        PDImageXObject xobject = img.getXObject();
        AffineTransform transformer = (AffineTransform)this.getTransform().clone();
        transformer.translate(x, y);
        transformer.translate(0.0, img.getHeight());
        AffineTransform normalized = this.normalizeMatrix(transformer);
        normalized.scale(img.getWidth(), -img.getHeight());
        double[] mx = new double[6];
        normalized.getMatrix(mx);
        this._cp.drawImage(xobject, (float)mx[4], (float)mx[5], (float)mx[0], (float)mx[3]);
    }

    public float getDotsPerPoint() {
        return this._dotsPerPoint;
    }

    public void start(Document doc) {
        this._linkManager = new PdfBoxLinkManager(this._sharedContext, this._dotsPerPoint, this._root, this);
        this.loadBookmarks(doc);
        this.loadMetadata(doc);
    }

    public void finish(RenderingContext c, Box root) {
        this._linkManager.processLinks();
        this.writeOutline(c, root);
    }

    private void writeOutline(RenderingContext c, Box root) {
        if (this._bookmarks.size() > 0) {
            PDDocumentOutline outline = new PDDocumentOutline();
            this._writer.getDocumentCatalog().setDocumentOutline(outline);
            this.writeBookmarks(c, root, (PDOutlineNode)outline, this._bookmarks);
        }
    }

    private void writeBookmarks(RenderingContext c, Box root, PDOutlineNode parent, List bookmarks) {
        for (Bookmark bookmark : bookmarks) {
            this.writeBookmark(c, root, parent, bookmark);
        }
    }

    int getPageRefY(Box box) {
        if (box instanceof InlineLayoutBox) {
            InlineLayoutBox iB = (InlineLayoutBox)box;
            return iB.getAbsY() + iB.getBaseline();
        }
        return box.getAbsY();
    }

    private void writeBookmark(RenderingContext c, Box root, PDOutlineNode parent, Bookmark bookmark) {
        Box box;
        String href = bookmark.getHRef();
        PDDestination target = null;
        if (href.length() > 0 && href.charAt(0) == '#' && (box = this._sharedContext.getBoxById(href.substring(1))) != null) {
            PageBox page = root.getLayer().getPage((CssContext)c, this.getPageRefY(box));
            int distanceFromTop = page.getMarginBorderPadding((CssContext)c, 3);
            target = new PDPageXYZDestination();
            target.setTop((int)this.normalizeY((float)(distanceFromTop += box.getAbsY() - page.getTop()) / this._dotsPerPoint));
            target.setPage(this._writer.getPage(this._startPageNo + page.getPageNo()));
        }
        PDOutlineItem outline = new PDOutlineItem();
        outline.setDestination(target == null ? this._defaultDestination : target);
        outline.setTitle(bookmark.getName());
        parent.addLast(outline);
        this.writeBookmarks(c, root, (PDOutlineNode)outline, bookmark.getChildren());
    }

    private void loadBookmarks(Document doc) {
        List l;
        Element bookmarks;
        Element head = DOMUtil.getChild(doc.getDocumentElement(), "head");
        if (head != null && (bookmarks = DOMUtil.getChild(head, "bookmarks")) != null && (l = DOMUtil.getChildren(bookmarks, "bookmark")) != null) {
            for (Element e : l) {
                this.loadBookmark(null, e);
            }
        }
    }

    private void loadBookmark(Bookmark parent, Element bookmark) {
        Bookmark us = new Bookmark(bookmark.getAttribute("name"), bookmark.getAttribute("href"));
        if (parent == null) {
            this._bookmarks.add(us);
        } else {
            parent.addChild(us);
        }
        List l = DOMUtil.getChildren(bookmark, "bookmark");
        if (l != null) {
            for (Element e : l) {
                this.loadBookmark(us, e);
            }
        }
    }

    public void addMetadata(String name, String value) {
        if (name != null && value != null) {
            Metadata m = new Metadata(name, value);
            this._metadata.add(m);
        }
    }

    public String getMetadataByName(String name) {
        if (name != null) {
            int len = this._metadata.size();
            for (int i = 0; i < len; ++i) {
                Metadata m = (Metadata)this._metadata.get(i);
                if (m == null || !m.getName().equalsIgnoreCase(name)) continue;
                return m.getContent();
            }
        }
        return null;
    }

    public ArrayList getMetadataListByName(String name) {
        ArrayList<String> result = new ArrayList<String>();
        if (name != null) {
            int len = this._metadata.size();
            for (int i = 0; i < len; ++i) {
                Metadata m = (Metadata)this._metadata.get(i);
                if (m == null || !m.getName().equalsIgnoreCase(name)) continue;
                result.add(m.getContent());
            }
        }
        return result;
    }

    private void loadMetadata(Document doc) {
        Element head = DOMUtil.getChild(doc.getDocumentElement(), "head");
        if (head != null) {
            Element t;
            String title;
            List l = DOMUtil.getChildren(head, "meta");
            if (l != null) {
                for (Element e : l) {
                    String name = e.getAttribute("name");
                    if (name == null) continue;
                    String content = e.getAttribute("content");
                    Metadata m = new Metadata(name, content);
                    this._metadata.add(m);
                }
            }
            if ((title = this.getMetadataByName("title")) == null && (t = DOMUtil.getChild(head, "title")) != null) {
                title = DOMUtil.getText(t).trim();
                Metadata m = new Metadata("title", title);
                this._metadata.add(m);
            }
        }
    }

    public void setMetadata(String name, String value) {
        if (name != null) {
            boolean remove = value == null;
            int free = -1;
            int len = this._metadata.size();
            for (int i = 0; i < len; ++i) {
                Metadata m = (Metadata)this._metadata.get(i);
                if (m != null) {
                    if (!m.getName().equalsIgnoreCase(name)) continue;
                    if (!remove) {
                        remove = true;
                        m.setContent(value);
                        continue;
                    }
                    this._metadata.set(i, null);
                    continue;
                }
                if (free != -1) continue;
                free = i;
            }
            if (!remove) {
                Metadata m = new Metadata(name, value);
                if (free == -1) {
                    this._metadata.add(m);
                } else {
                    this._metadata.set(free, m);
                }
            }
        }
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public void setSharedContext(SharedContext sharedContext) {
        this._sharedContext = sharedContext;
        sharedContext.getCss().setSupportCMYKColors(true);
    }

    public void setRoot(Box root) {
        this._root = root;
    }

    public int getStartPageNo() {
        return this._startPageNo;
    }

    public void setStartPageNo(int startPageNo) {
        this._startPageNo = startPageNo;
    }

    public void drawSelection(RenderingContext c, InlineText inlineText) {
        throw new UnsupportedOperationException();
    }

    public boolean isSupportsSelection() {
        return false;
    }

    public boolean isSupportsCMYKColors() {
        return true;
    }

    public List findPagePositionsByID(CssContext c, Pattern pattern) {
        Map idMap = this._sharedContext.getIdMap();
        if (idMap == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PagePosition> result = new ArrayList<PagePosition>();
        for (Map.Entry entry : idMap.entrySet()) {
            Box box;
            PagePosition pos;
            String id = (String)entry.getKey();
            if (!pattern.matcher(id).find() || (pos = this.calcPDFPagePosition(c, id, box = (Box)entry.getValue())) == null) continue;
            result.add(pos);
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                PagePosition p1 = (PagePosition)arg0;
                PagePosition p2 = (PagePosition)arg1;
                return p1.getPageNo() - p2.getPageNo();
            }
        });
        return result;
    }

    private PagePosition calcPDFPagePosition(CssContext c, String id, Box box) {
        PageBox page = this._root.getLayer().getLastPage(c, box);
        if (page == null) {
            return null;
        }
        float x = box.getAbsX() + page.getMarginBorderPadding(c, 1);
        float y = page.getBottom() - (box.getAbsY() + box.getHeight()) + page.getMarginBorderPadding(c, 4);
        PagePosition result = new PagePosition();
        result.setId(id);
        result.setPageNo(page.getPageNo());
        result.setX(x /= this._dotsPerPoint);
        result.setY(y /= this._dotsPerPoint);
        result.setWidth((float)box.getEffectiveWidth() / this._dotsPerPoint);
        result.setHeight((float)box.getHeight() / this._dotsPerPoint);
        return result;
    }

    public void setRenderingContext(RenderingContext result) {
        this._renderingContext = result;
    }

    public void setBidiReorderer(BidiReorderer reorderer) {
        this._reorderer = reorderer;
    }

    private static class Metadata {
        private String _name;
        private String _content;

        public Metadata(String name, String content) {
            this._name = name;
            this._content = content;
        }

        public String getContent() {
            return this._content;
        }

        public void setContent(String content) {
            this._content = content;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }
    }

    private static class Bookmark {
        private String _name;
        private String _HRef;
        private List _children;

        public Bookmark() {
        }

        public Bookmark(String name, String href) {
            this._name = name;
            this._HRef = href;
        }

        public String getHRef() {
            return this._HRef;
        }

        public void setHRef(String href) {
            this._HRef = href;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public void addChild(Bookmark child) {
            if (this._children == null) {
                this._children = new ArrayList();
            }
            this._children.add(child);
        }

        public List getChildren() {
            return this._children == null ? Collections.EMPTY_LIST : this._children;
        }
    }

    static class FontRun {
        String str;
        PdfBoxFontResolver.FontDescription des;

        FontRun() {
        }
    }
}

