/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.objects.pdf;

import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.objects.pdf.PdfDrawerBase;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.render.RenderingContext;
import java.awt.Shape;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.util.Charsets;
import org.w3c.dom.Element;

public class MergeBackgroundPdfDrawer
extends PdfDrawerBase {
    public Map<Shape, String> drawObject(Element e, double x, double y, double width, double height, OutputDevice outputDevice, RenderingContext ctx, int dotsPerPixel) {
        if (!(outputDevice instanceof PdfBoxOutputDevice)) {
            return null;
        }
        PdfBoxOutputDevice pdfBoxOutputDevice = (PdfBoxOutputDevice)outputDevice;
        try {
            LayerUtility layerUtility = new LayerUtility(pdfBoxOutputDevice.getWriter());
            PDFormXObject pdFormXObject = this.importPageAsXForm(ctx, e, pdfBoxOutputDevice, layerUtility);
            PDPage page = pdfBoxOutputDevice.getPage();
            layerUtility.wrapInSaveRestore(page);
            COSArray cosArray = (COSArray)page.getCOSObject().getDictionaryObject(COSName.CONTENTS);
            COSStream saveStateAndPlacePageBackgroundStream = (COSStream)cosArray.get(0);
            OutputStream saveAndPlaceStream = saveStateAndPlacePageBackgroundStream.createOutputStream();
            saveAndPlaceStream.write("q\n".getBytes(Charsets.US_ASCII));
            COSName name = page.getResources().add(pdFormXObject);
            name.writePDF(saveAndPlaceStream);
            saveAndPlaceStream.write(32);
            saveAndPlaceStream.write("Do\n".getBytes(Charsets.US_ASCII));
            saveAndPlaceStream.write("Q\n".getBytes(Charsets.US_ASCII));
            saveAndPlaceStream.write("q\n".getBytes(Charsets.US_ASCII));
            saveAndPlaceStream.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return null;
    }
}

