/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.css.parser.FSColor;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.derived.FSLinearGradient;
import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.OutputDeviceGraphicsDrawer;
import com.openhtmltopdf.extend.ReplacedElement;
import com.openhtmltopdf.extend.StructureType;
import com.openhtmltopdf.java2d.Java2DFont;
import com.openhtmltopdf.java2d.api.Java2DRendererBuilder;
import com.openhtmltopdf.render.AbstractOutputDevice;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.render.InlineText;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.swing.AWTFSImage;
import com.openhtmltopdf.swing.ImageReplacedElement;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

public class Java2DOutputDevice
extends AbstractOutputDevice
implements OutputDevice {
    private final Deque<Shape> _clipStack = new ArrayDeque<Shape>();
    private final Deque<AffineTransform> _transformStack = new ArrayDeque<AffineTransform>();
    private Graphics2D _graphics;
    private Java2DFont _font;

    public Java2DOutputDevice(Graphics2D layoutGraphics) {
        this._graphics = layoutGraphics;
    }

    @Deprecated
    public void drawSelection(RenderingContext c, InlineText inlineText) {
    }

    public void drawBorderLine(Shape bounds, int side, int lineWidth, boolean solid) {
        this.draw(bounds);
    }

    public void paintReplacedElement(RenderingContext c, BlockBox box) {
        ReplacedElement replaced = box.getReplacedElement();
        if (replaced instanceof ImageReplacedElement) {
            Image image = ((ImageReplacedElement)replaced).getImage();
            Point location = replaced.getLocation();
            this._graphics.drawImage(image, (int)location.getX(), (int)location.getY(), null);
        } else if (replaced instanceof Java2DRendererBuilder.Graphics2DPaintingReplacedElement) {
            Rectangle contentBounds = box.getContentAreaEdge(box.getAbsX(), box.getAbsY(), (CssContext)c);
            ((Java2DRendererBuilder.Graphics2DPaintingReplacedElement)replaced).paint(this, c, contentBounds.x, contentBounds.y, contentBounds.width, contentBounds.height);
        }
    }

    public void setColor(FSColor color) {
        if (!(color instanceof FSRGBColor)) {
            throw new RuntimeException("internal error: unsupported color class " + color.getClass().getName());
        }
        FSRGBColor rgb = (FSRGBColor)color;
        this._graphics.setColor(new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue()));
    }

    protected void drawLine(int x1, int y1, int x2, int y2) {
        this._graphics.drawLine(x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int width, int height) {
        this._graphics.drawRect(x, y, width, height);
    }

    public void fillRect(int x, int y, int width, int height) {
        this._graphics.fillRect(x, y, width, height);
    }

    @Deprecated
    public void setClip(Shape s) {
    }

    @Deprecated
    public Shape getClip() {
        return null;
    }

    @Deprecated
    public void clip(Shape s) {
    }

    public void translate(double tx, double ty) {
        this._graphics.translate(tx, ty);
    }

    public Graphics2D getGraphics() {
        return this._graphics;
    }

    public void drawOval(int x, int y, int width, int height) {
        this._graphics.drawOval(x, y, width, height);
    }

    public void fillOval(int x, int y, int width, int height) {
        this._graphics.fillOval(x, y, width, height);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this._graphics.getRenderingHint(key);
    }

    public void setRenderingHint(RenderingHints.Key key, Object value) {
        this._graphics.setRenderingHint(key, value);
    }

    public void setFont(FSFont font) {
        this._font = (Java2DFont)font;
        this._graphics.setFont(this._font.getAWTFonts().get(0));
    }

    public Java2DFont getFont() {
        return this._font;
    }

    public void setStroke(Stroke s) {
        this._graphics.setStroke(s);
    }

    public Stroke getStroke() {
        return this._graphics.getStroke();
    }

    public void fill(Shape s) {
        this._graphics.fill(s);
    }

    public void draw(Shape s) {
        this._graphics.draw(s);
    }

    public void drawImage(FSImage image, int x, int y, boolean interpolate) {
        Object oldInterpolation = this._graphics.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        if (interpolate) {
            this._graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        } else {
            this._graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        this._graphics.drawImage((Image)((AWTFSImage)image).getImage(), x, y, null);
        if (oldInterpolation != null) {
            this._graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, oldInterpolation);
        }
    }

    @Deprecated
    public boolean isSupportsSelection() {
        return false;
    }

    public boolean isSupportsCMYKColors() {
        return false;
    }

    public void drawWithGraphics(float x, float y, float width, float height, OutputDeviceGraphicsDrawer renderer) {
        Graphics2D graphics = (Graphics2D)this._graphics.create((int)x, (int)y, (int)width, (int)height);
        renderer.render(graphics);
        graphics.dispose();
    }

    public void setPaint(Paint paint) {
        this._graphics.setPaint(paint);
    }

    @Deprecated
    public List<AffineTransform> pushTransforms(List<AffineTransform> transforms) {
        return null;
    }

    @Deprecated
    public void popTransforms(List<AffineTransform> inverse) {
    }

    @Deprecated
    public float getAbsoluteTransformOriginX() {
        return 0.0f;
    }

    @Deprecated
    public float getAbsoluteTransformOriginY() {
        return 0.0f;
    }

    public void setBidiReorderer(BidiReorderer _reorderer) {
    }

    public void setRenderingContext(RenderingContext result) {
    }

    public void setRoot(BlockBox _root) {
    }

    public void initializePage(Graphics2D pageGraphics) {
        this._graphics = pageGraphics;
        if (this._graphics.getClip() != null) {
            this._clipStack.push(this._graphics.getClip());
        }
        if (this._graphics.getTransform() != null) {
            this._transformStack.push(this._graphics.getTransform());
        } else {
            this._transformStack.push(new AffineTransform());
        }
    }

    public void finish(RenderingContext c, BlockBox _root) {
    }

    public void pushTransformLayer(AffineTransform transform) {
        this._graphics.transform(transform);
        this._transformStack.push(this._graphics.getTransform());
    }

    public void popTransformLayer() {
        this._transformStack.pop();
        AffineTransform transform = this._transformStack.peek();
        this._graphics.setTransform(transform);
    }

    public void popClip() {
        this._clipStack.pop();
        Shape previous = this._clipStack.peek();
        this._graphics.setClip(previous);
    }

    public void pushClip(Shape s) {
        this._graphics.clip(s);
        this._clipStack.push(this._graphics.getClip());
    }

    public boolean isFastRenderer() {
        return true;
    }

    public Object startStructure(StructureType type, Box box) {
        return null;
    }

    public void endStructure(Object token) {
    }

    public void drawLinearGradient(FSLinearGradient lg, Shape bounds) {
        if (lg.getStopPoints().size() < 2) {
            return;
        }
        Color[] colors = new Color[lg.getStopPoints().size()];
        float[] fractions = new float[lg.getStopPoints().size()];
        float maxLength = ((FSLinearGradient.StopPoint)lg.getStopPoints().get(lg.getStopPoints().size() - 1)).getLength();
        if (maxLength == 0.0f) {
            return;
        }
        for (int i = 0; i < lg.getStopPoints().size(); ++i) {
            FSLinearGradient.StopPoint sp = (FSLinearGradient.StopPoint)lg.getStopPoints().get(i);
            FSRGBColor col = (FSRGBColor)sp.getColor();
            colors[i] = new Color((float)col.getRed() / 255.0f, (float)col.getGreen() / 255.0f, (float)col.getBlue() / 255.0f);
            fractions[i] = sp.getLength() / maxLength;
        }
        Rectangle rect = bounds.getBounds();
        Point2D.Double pt1 = new Point2D.Double((double)lg.getX1() + rect.getMinX(), (double)lg.getY1() + rect.getMinY());
        Point2D.Double pt2 = new Point2D.Double((double)lg.getX2() + rect.getMinX(), (double)lg.getY2() + rect.getMinY());
        Paint oldPaint = this._graphics.getPaint();
        this._graphics.setPaint(new LinearGradientPaint(pt1, pt2, fractions, colors));
        this._graphics.fill(bounds);
        this._graphics.setPaint(oldPaint);
    }
}

