/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.util;

import com.openhtmltopdf.util.Configuration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class XRSimpleLogFormatter
extends Formatter {
    private final MessageFormat mformat = new MessageFormat(msgFmt);
    private final MessageFormat exmformat = new MessageFormat(exmsgFmt);
    private static final String msgFmt = Configuration.valueFor("xr.simple-log-format", "{1} {2}:: {5}").trim() + "\n";
    private static final String exmsgFmt = Configuration.valueFor("xr.simple-log-format-throwable", "{1} {2}:: {5}").trim() + "\n";
    private final boolean[] usedPlaceholderForMsgFmt = XRSimpleLogFormatter.usedPlaceholder(this.mformat);
    private final boolean[] usedPlaceholderForExmsgFmt = XRSimpleLogFormatter.usedPlaceholder(this.exmformat);

    private static boolean[] usedPlaceholder(MessageFormat messageFormat) {
        boolean[] used = new boolean[9];
        String identifier = UUID.randomUUID().toString();
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < 9; ++i) {
            args.add('{' + identifier + '-' + i + '}');
        }
        String res = messageFormat.format(args.stream().toArray());
        for (int i = 0; i < 9; ++i) {
            used[i] = res.contains((CharSequence)args.get(i));
        }
        return used;
    }

    @Override
    public String format(LogRecord record) {
        Throwable th = record.getThrown();
        boolean[] placeholderUse = th == null ? this.usedPlaceholderForMsgFmt : this.usedPlaceholderForExmsgFmt;
        String thName = "";
        String thMessage = "";
        String trace = null;
        if (th != null) {
            if (placeholderUse[8]) {
                StringWriter sw = new StringWriter();
                th.printStackTrace(new PrintWriter(sw));
                trace = sw.toString();
            }
            thName = th.getClass().getName();
            thMessage = th.getMessage();
        }
        String[] args = new String[]{placeholderUse[0] ? String.valueOf(record.getMillis()) : null, placeholderUse[1] ? record.getLoggerName() : null, placeholderUse[2] ? record.getLevel().toString() : null, placeholderUse[3] ? record.getSourceClassName() : null, placeholderUse[4] ? record.getSourceMethodName() : null, placeholderUse[5] ? record.getMessage() : null, placeholderUse[6] ? thName : null, placeholderUse[7] ? thMessage : null, placeholderUse[8] ? trace : null};
        return th == null ? this.mformat.format(args) : this.exmformat.format(args);
    }

    @Override
    public String formatMessage(LogRecord record) {
        return super.formatMessage(record);
    }

    @Override
    public String getHead(Handler h) {
        return super.getHead(h);
    }

    @Override
    public String getTail(Handler h) {
        return super.getTail(h);
    }
}

