/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.util;

import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;

public class StreamResource {
    private final String _uri;
    private URLConnection _conn;
    private int _slen;
    private InputStream _inputStream;

    public StreamResource(String uri) {
        this._uri = uri;
    }

    public void connect() {
        try {
            this._conn = new URL(this._uri).openConnection();
            this._conn.setConnectTimeout(10000);
            this._conn.setReadTimeout(30000);
            this._conn.connect();
            this._slen = this._conn.getContentLength();
        }
        catch (MalformedURLException e) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_MALFORMED_URL, (Object)this._uri, e);
        }
        catch (FileNotFoundException e) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_ITEM_AT_URI_NOT_FOUND, (Object)this._uri, e);
        }
        catch (IOException e) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_IO_PROBLEM_FOR_URI, (Object)this._uri, e);
        }
    }

    public boolean hasStreamLength() {
        return this._slen >= 0;
    }

    public int streamLength() {
        return this._slen;
    }

    public BufferedInputStream bufferedStream() throws IOException {
        this._inputStream = this._conn.getInputStream();
        return new BufferedInputStream(this._inputStream);
    }

    public void close() {
        if (this._inputStream != null) {
            try {
                this._inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

