/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.resource;

import com.openhtmltopdf.resource.FSCatalog;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FSEntityResolver
implements EntityResolver {
    private static final FSEntityResolver instance = new FSEntityResolver();
    private final Map<String, String> entities = new HashMap<String, String>();

    private FSEntityResolver() {
        FSCatalog catalog = new FSCatalog();
        this.entities.putAll(catalog.parseCatalog("/resources/schema/openhtmltopdf/catalog-special.xml"));
    }

    @Override
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        InputSource local = null;
        String url = this.getEntities().get(publicID);
        if (url != null) {
            URL realUrl = FSEntityResolver.class.getResource(url);
            InputStream is = null;
            try {
                is = realUrl.openStream();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (is == null) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId2Param.XML_ENTITIES_ENTITY_CANT_FIND_LOCAL_REFERENCE, (Object)publicID, (Object)url);
            }
            local = new InputSource(is);
            local.setSystemId(realUrl.toExternalForm());
            XRLog.log(Level.FINE, LogMessageId.LogMessageId2Param.XML_ENTITIES_ENTITY_PUBLIC_NOT_FOUND_OR_LOCAL, (Object)publicID, (Object)(url + (local == null ? ", NOT FOUND" : " (local)")));
        } else {
            XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.XML_ENTITIES_ENTITY_PUBLIC_NO_LOCAL_MAPPING, publicID);
            local = new InputSource(new StringReader(""));
        }
        return local;
    }

    public static FSEntityResolver instance() {
        return instance;
    }

    public Map<String, String> getEntities() {
        return Collections.unmodifiableMap(this.entities);
    }
}

